#include <linux/module.h>
#include <linux/smp.h>
#include <linux/user.h>
#include <linux/elfcore.h>
#include <asm/segment.h>
#include <linux/delay.h>	/* __do_delay (YHP) */

extern void dump_thread(struct pt_regs *, struct user *);
extern int dump_fpu(elf_fpregset_t *);
extern asmlinkage int internal_sys_clone(struct pt_regs regs);	/* (YHP) */
extern asmlinkage int herc_printf(const char *fmt,...);		/* (YHP) */

static struct symbol_table arch_symbol_table = {
#include <linux/symtab_begin.h>
	/* platform dependent support */
	X(dump_thread),
	X(dump_fpu),
	XNOVERS(down_failed),
	XNOVERS(up_wakeup),
	X(memcpy_tofs),
	X(memcpy_fromfs),
	X(put_user_long),
	X(put_user_word),
	X(put_user_byte),
	X(get_user_long),
	X(get_user_word),
	X(get_user_byte),
	X(set_fs),		/* asm/segment.h (YHP) */
	X(__do_delay),		/* lib/delay.S (YHP) */
	X(internal_sys_clone),	/* kernel/process.c (YHP) */
	X(herc_printf),		/* lib/herc_printf.c (YHP) */
#include <linux/symtab_end.h>
};

void arch_syms_export(void)
{
	register_symtab(&arch_symbol_table);
}
