/* $Id: process.c,v 1.1.1.1 1999/04/06 19:21:05 yoonho Exp $
 *
 *  linux/arch/l4-i386/kernel/process.c
 *
 *  Copyright (C) 1995  Linus Torvalds
 */

/*
 * This file handles the architecture-dependent parts of process handling..
 */

#include <l4/types.h>

#include <linux/ptrace.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/a.out.h>
#include <linux/user.h>
#include <asm/segment.h>
#include <asm/io.h>
#include <asm/system.h>

#include <l4/ipc.h>

#include "../include/config.h"
#include "../include/rmgr.h"
#include "../include/task.h"
#include "../include/user.h"
#include "../include/exclpage.h"
#include "../include/assert.h"
#include "../include/l4_memory.h"
#include "../include/lock.h"
#include "../include/linuxipc.h"
#include "../include/debug.h"
#include "../include/perform.h"
#include "../include/l4_memory.h"  /* handle_pagefault */
#include "../include/dispatch.h"   /* handle_syscall */

#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>

/* #define HACKED_CLONE */
#define CLONE_HACK 0x00002000

#define DIRECT_DISPATCH	/* deactivate original version */
/* #define DEBUG_IPC  *//* activate ipc debugging, dw2 contains the low part
		     of the sending thread, double check against src id */
/* #define VERBOSE_HANDLE_MSG */
/* #define MEASURE_SYSCALL_PATH */
/* #define MEASURE_DISPATCH_TIME */
#if 0
#define SCHED_KO(x) ko(x)
#else
#define SCHED_KO(x)
#endif

#ifdef USE_SUPER_CLAN
# define l4_task_new rmgr_task_new
#endif

#define IDLE_TIMEOUT L4_IPC_TIMEOUT(0, 0, 1, 5, 0, 0) /* one second timeout */

#define DEBUG_STACK
/* #define DEBUG */
/* msg transfer */
#define DISPATCH_TIMEOUT L4_IPC_TIMEOUT(0,1,0,0,0,0) /* rcv = inf, snd = 0 */

int idle_sleeping = 0;

asmlinkage int sys_idle(void)
{
  void l4_idle(void *kernel_sp); /* in l4_idle.S */

  if (current->pid != 0)
    return -EPERM;

  current->counter = -100;
  l4_idle(&current->tss.kernel_sp);
  return 0;			/* never reached? */
}
asmlinkage int sys_enosys(void)
{
  return -ENOSYS;
}

/*
 * This routine reboots the machine by asking the keyboard
 * controller to pulse the reset-line low. We try that for a while,
 * and if it doesn't work, we do some other stupid things.
 */
#if 0
static long no_idt[2] = {0, 0};
#endif

static inline void kb_wait(void)
{
	int i;

	for (i=0; i<0x10000; i++)
		if ((inb_p(0x64) & 0x02) == 0)
			break;
}

void hard_reset_now(void)
{
	int i, j;

	sti();
#ifdef DEBUG
	enter_kdebug("hard_reset_now");
#endif
/* rebooting needs to touch the page at absolute addr 0 */
	pg0[0] = 7;		/* XXX make pg0 writable */
	request_zero_page_from_sigma0();
	*((unsigned short *)0x472) = 0x1234;
	for (;;) {
		for (i=0; i<100; i++) {
			kb_wait();
			for(j = 0; j < 100000 ; j++)
				/* nothing */;
			outb(0xfe,0x64);	 /* pulse reset low */
		}
#if 0
		/* XXX generate triple fault */
		__asm__ __volatile__("\tlidt %0": "=m" (no_idt));
#endif
	}
}

void show_regs(struct pt_regs * regs)
{
  printk("\n");

  if (! regs)
    {
      printk("Can't print regs from interrupt handler: &pt_regs == 0!");
      return;
    }

  printk("EIP: %08lx", regs->eip);
  printk(" ESP: %08lx", regs->esp);
  printk(" EFLAGS: %08lx\n",regs->eflags);
  printk("EAX: %08lx EBX: %08lx ECX: %08lx EDX: %08lx\n",
	 regs->eax,regs->ebx,regs->ecx,regs->edx);
  printk("ESI: %08lx EDI: %08lx EBP: %08lx\n",
	 regs->esi, regs->edi, regs->ebp);
}


extern int l4_task_version;
static int get_new_taskno(l4_taskid_t *task)
{
  int n = task_no_alloc();

  if (n < 0)
    return n;

  *task = template_id;
  task->id.lthread = 0;
  task->id.task = n;
  task->id.version_low = l4_task_version;

#ifdef DEBUG
  printk("get_new_task_no: allocated id: %x\n", task->lh.low);
#endif
  return 0;
}

/*
 * Free current thread data structures etc..
 */

/* delete a task */
extern inline int 
task_delete(l4_threadid_t task)
{
  l4_task_new(task, root_pager_id.lh.low, 0, 0, L4_NIL_ID);
  return 0;
}

/* called by do_exit(); kills the Linux user thread */
void exit_thread(void)
{
  /* check if we were a kernel-internal thread (i.e., have no
     user-space partner */
  if (! thread_equal(current->tss.user_thread_id, L4_NIL_ID))
    {
      l4_taskid_t task;

      /* kill the associated user task */
      task = get_taskid(current->tss.user_thread_id);
#ifdef DEBUG
      printk("exit_thread: trying to delete %x\n", 
	     task.lh.low);
#if 0
      enter_kdebug("exit_thread");
#endif
#endif

      if (task_delete(task)
	  < 0)
	{
	  panic("exit_thread: root_task_execute(task_delete) failed");
	}

      task_no_free(task.id.task);
      task_to_proc[task.id.task] = 0;
    }

  free_page((unsigned long) current->tss.ex_page);

  /* we can't delete the L4 thread running in kernel mode associated
     with this Linux task because _we_ are the thread in question... 
     That's why, leave the work to release_thread(). */
}

/* called by release(); should free any data structures still held
   after exit_thread() */
void release_thread(struct task_struct *dead_task)
{
#ifdef DEBUG_STACK
  unsigned int ustack;
#endif

#ifdef DEBUG_STACK
  if ((ustack = stack_used((char*)dead_task->kernel_stack_page+PAGE_SIZE,
			   (char*)dead_task->kernel_stack_page))
      > PAGE_SIZE - 0x100)
    printk("release_thread: thread %s(%d) used"
	   " %d bytes stack maximum at %lx\n",
	   dead_task->comm, dead_task->pid,
	   ustack,
	   dead_task->kernel_stack_page+PAGE_SIZE);
#endif
  if (STACK_MAGIC != *(unsigned long *)dead_task->kernel_stack_page)
    {
      printk(KERN_ALERT "release_thread: %s kernel stack corruption"
	     " at %lx. Aiee\n", dead_task->comm,
	     dead_task->kernel_stack_page);
      enter_kdebug("release stack size check");
    }
}


static void
kernel_thread_init(struct task_struct *p, unsigned long clone_flags)
{
#ifdef DEBUG
  printk("(%x.%x)kernel_thread_init: called with task_struct %x, "
	 "clone_flags: %x\n",
	 l4_myself().id.task, l4_myself().id.lthread,
	 (unsigned int)p, (unsigned int)clone_flags);
  if (p->tss.page_dir == swapper_pg_dir)
    printk("kernel_thread_init: p->tss.page_dir == swapper_pg_dir\n");
  else
    printk("kernel_thread_init: p->tss.page_dir (%lx) "
	   "!= swapper_pg_dir (%lx)\n", (unsigned long)p->tss.page_dir, 
	   (unsigned long)swapper_pg_dir);
  show_regs(&p->tss.ex_page->regs);
#endif

  if (p != current)
    enter_kdebug("i'm not current");

  if (p->tss.page_dir == swapper_pg_dir)
    {
      struct pt_regs *pt_regsp = &p->tss.ex_page->regs;

      /* restore registers and continue within new thread */
#define __MOV_REG(offs,reg) "movl " #offs "(%%ebx)," reg "\n\t"
#define MOV_REG(offs,reg) __MOV_REG(offs, "%%" #reg)
      asm volatile
	(
	 "pushl	%%eax	\n\t" /* push the return address (new control 
				 flow */
	 "pushl	%%ecx	\n\t" /* push the value of eflags */
	 "pushl	%%edx	\n\t" /* push the value of ebx */
	 
	 MOV_REG(OFFS_EAX, eax)
	 MOV_REG(OFFS_ECX, ecx)
	 MOV_REG(OFFS_EDX, edx)
	 MOV_REG(OFFS_ESI, esi)
	 MOV_REG(OFFS_EDI, edi)
	 MOV_REG(OFFS_EBP, ebp)
	 
	 "popl		%%ebx	\n\t" /* restore ebx */
	 "popfl 		\n\t" /* restore eflags */
/* 	 asm_enter_kdebug("kernel_thread_init: returning to ptregs.eip")  */
	 "ret			\n\t" /* return to original control flow */
	 : 
	 /* No Output */
	 : 
	 "b" (pt_regsp),	/* address of pt regs structure */
	 "a" (pt_regsp->eip),	/* EIP */
	 "c" (pt_regsp->eflags), /* EFLAGS */
	 "d" (pt_regsp->ebx)	/* EBX */
	 );
      panic("kernel_thread_init: return after jump to new control flow");
    }
  else
    {
      /* activate request handling */
      enter_kdebug("activating request handling");
      do_exit(9);
    }
}

/* create an L4 task pair (kernel/user mode) for the new task_struct;
   copy_thread() will invoke this routine in the Linux server's root
   task */

static int 
#ifdef HACKED_CLONE
task_pair_create_user(struct thread_struct *t,
                      unsigned long clone_flags)
#else /* HACKED_CLONE */
task_pair_create_user(struct thread_struct *t)
#endif /* HACKED_CLONE */
{
  l4_taskid_t task /* , foo_id -- Unused (YHP */ ;
  unsigned long *sp;
  extern l4_sched_param_t template_schedparam;
  /* l4_sched_param_t schedparam; -- Unused (YHP) */

  /* warning: sp is an address in user space; don't try to dereference
     it in the kernel */
  sp = (unsigned long *)(USIGNAL_STACK_INIT);
  t->under_kernel_control = 0;
  t->ex_page->emu_local_lock = 1;

#ifndef USE_SUPER_CLAN
  task = l4_task_new(t->user_thread_id, 0, (dword_t) sp, 
		     (dword_t) user_task_init, kernel_thread_id); 
#else
#ifdef HACKED_CLONE
{
  l4_threadid_t pager = kernel_thread_id;

  if (clone_flags & CLONE_HACK)
    pager = current->tss.user_thread_id;
  task = rmgr_task_new_with_prio(t->user_thread_id, 0, 
				 (dword_t) sp, (dword_t) user_task_init, 
				 pager, template_schedparam); 
}
#else /* HACKED_CLONE */
  task = rmgr_task_new_with_prio(t->user_thread_id, 0, 
				 (dword_t) sp, (dword_t) user_task_init, 
				 kernel_thread_id, template_schedparam); 
#endif /* HACKED_CLONE */
#endif
  if (thread_equal(task, L4_NIL_ID)) 
    {
      printk("task_pair_create_user: Failed to create user task\n");
      task_no_free(t->user_thread_id.id.task);
      return -EBUSY;
    }
#ifndef USE_SUPER_CLAN
  /* XXX should set prio of user task here if desired differently from
     kernel prio */
  l4_thread_schedule(task, template_schedparam, &foo_id, &foo_id, 
		     &schedparam);
#endif  

  
  return 0;
}

static int 
task_pair_create(struct task_struct *p,
		 unsigned long clone_flags)
{
  struct thread_struct *t = &p->tss;
  l4_taskid_t server_id;
  int code;
  unsigned long *sp;

#ifdef DEBUG_STACK
  stack_fill((char *) (p->kernel_stack_page + PAGE_SIZE), 
	     (char *) p->kernel_stack_page);
#endif
  /* first, allocate task id for  client task */
  if (t->page_dir != swapper_pg_dir)
    {
      if (get_new_taskno(&t->user_thread_id) < 0)
	{
	  task_no_free(server_id.id.task);
	  printk("task_pair_create: No task no left for user\n"); 
	  return -EBUSY;
	}
    }
  else
    {
      t->user_thread_id = L4_NIL_ID;
    }

  /* first, create the kernel part of the new task pair */
  t->ex_page->kernel_id = get_l4_id_from_stack();
  t->ex_page->user_id = t->user_thread_id; /* XXX this is just sanity */

  /* put thread id to top of stack */
  sp = (unsigned long *) (p->kernel_stack_page + PAGE_SIZE);
  sp -= (sizeof(l4_threadid_t) + sizeof(long))/ sizeof(*sp);
  put_l4_id_to_stack((unsigned)sp, get_l4_id_from_stack());

  *(unsigned long *)
  (((unsigned)sp & PAGE_MASK) + 
   PAGE_SIZE - sizeof(l4_threadid_t) - sizeof(long)) =
    (unsigned long) sig_kill_received;
  t->kernel_stack = (unsigned long)sp;
 
  /* emulate function call with two parameters on stack: */
  *(--sp) = clone_flags;
  *(--sp) = (unsigned long) p;
  *(--sp) = 0;			/* fake return address */

  /* switch_to will expect the new program pointer on the stack */
  *(--sp) = (unsigned long) kernel_thread_init;

  t->kernel_sp = (unsigned long) sp;

  /* if creating a kernel-internal thread, return at this point */
  if (t->page_dir == swapper_pg_dir)
    {
      t->under_kernel_control = 1;
/*       need_resched = 1; */
      return 0;
    }

  /* now create the user part of the new task */
#ifdef HACKED_CLONE
  if ((code = task_pair_create_user(t, clone_flags)) < 0)
#else /* HACKED_CLONE */
  if ((code = task_pair_create_user(t)) < 0)
#endif /* HACKED_CLONE */
    {
      /* kill kernel task */
      return code;
    }
  /* setup task-to-task_struct map entry */
  task_to_proc[t->user_thread_id.id.task] = p;			

  return 0;
}

/* set up a new task_struct p's tss/ldt/gdt with registers from regs
   (containing the do_fork() caller's regs).  create an L4 task pair
   (kernel/user mode) for the new task_struct */
void copy_thread(int nr, unsigned long clone_flags, unsigned long esp,
	struct task_struct * p, struct pt_regs * regs)
{
  struct pt_regs * childregs;

  /* initialize tss */

  /* allocate a new exclusive page */
  p->tss.ex_page = (struct exclusive_page_tag *) get_free_page(GFP_KERNEL);
  if (! p->tss.ex_page)
    {
      /* XXX currently, there is no way to report back an error. this
         will change with newer versions of Linux */
      panic("copy_thread: can't alloc ex_page");
    }

  ASSERT(p->kernel_stack_page);

#if 0
  /* XXX FIXME: 

     - we initialize 'struct exclusive_page' with zero (except stack
     bottoms)

     - gcc 2.8.x uses memset initialize 'struct exclusive_page' without
     providing an implementation for it 

     - 'struct exclusive_page' is allocated using get_free_page which
     already initializes the page with zero 

     Conclusion: If we guarantie, that all important fields are
     initialized correctly we can get rid of EX_PAGE_INITIALIZER 

     */
  *(p->tss.ex_page) =  (struct exclusive_page_tag)EX_PAGE_INITIALIZER;
#endif
  /* set up regs for child */
  childregs = & p->tss.ex_page->regs;
  *childregs = *regs;
  childregs->eax = 0;
  childregs->esp = esp;
  childregs->eflags |= 0x200;	/* sanity: set EI flag */

#ifdef DEBUG
  printk("copy_thread: esp: %x on_page: %x\n",(int)esp,(int)&childregs->esp);
#endif

  /* initialize fs to the old task's value.  this way, we make sure
     new kernel threads get KERNEL_DS, while new user threads get
     USER_DS in here.  when we go from kernel to user space in
     execve(), we change the value from KERNEL_DS to USER_DS (see
     below) */
  p->tss.fs = current->tss.fs;

  /* create the user/kernel task pair */
  if (task_pair_create(p, clone_flags)
      < 0)
    {
      /* XXX currently, there is no way to report back an error. this
         will change with newer versions of Linux */
      panic("root_task_execute(task_pair_create) failed");
    }
}

/* called by do_execve()/.../flush_old_exec(); should recycle the thread
   so that a new process can run in it */
void flush_thread(void)
{
  l4_taskid_t task = get_taskid(current->tss.user_thread_id);

  if ((! thread_equal(task, L4_NIL_ID))
      && task_delete(task) < 0)
    {
      /* XXX what should we do here? */
      enter_kdebug("flush_thread: delete failed");
    }
}

void start_thread(struct pt_regs * regs, unsigned long eip, 
		  unsigned long esp)
{
  regs->eip = eip;
  regs->esp = esp;

  if (eip > TASK_SIZE)
    send_sig(SIGSEGV, current, 0);
  
  current->tss.under_kernel_control = 2;
}

/* called by l4_idle.S when invoking a started thread */
void start_thread_really(void)
{
  struct thread_struct *t = &current->tss;

  if (t->under_kernel_control != 2)
    enter_kdebug("ukk != 2");

  /* create the task */

#ifdef HACKED_CLONE
  if (task_pair_create_user(t, 0) < 0)
#else /* HACKED_CLONE */
  if (task_pair_create_user(t) < 0)
#endif /* HACKED_CLONE */
    {
      /* XXX what should we do here? */
      enter_kdebug("start thread failed");
    }

  /* Note: task_pair_create_user() will have the side effect of
     cleaning the processes under_kernel_control flag -- which is okay */
}


/* core dump routines */

int dump_fpu (struct user_i387_struct *foo)
{
  return 0;			/* can't dump fpu state */
}

/* next is from arch/i386/kernel/process.c and adjusted to new pt_regs
   structure */
void dump_thread(struct pt_regs * regs, struct user * dump)
{
  int i;

  /* changed the size calculations - should hopefully work better. lbt */
  dump->magic = CMAGIC;
  dump->start_code = 0;
  dump->start_stack = regs->esp & ~(PAGE_SIZE - 1);
  dump->u_tsize = ((unsigned long) current->mm->end_code)
    >> PAGE_SHIFT;
  dump->u_dsize = ((unsigned long) (current->mm->brk + (PAGE_SIZE-1))) 
    >> PAGE_SHIFT;
  dump->u_dsize -= dump->u_tsize;
  dump->u_ssize = 0;
#if 0				/* XXX */
  for (i = 0; i < 8; i++)
    dump->u_debugreg[i] = current->debugreg[i];  
#else
  for (i = 0; i < 8; i++)
    dump->u_debugreg[i] = 0;
#endif

  if (dump->start_stack < TASK_SIZE)
    dump->u_ssize = ((unsigned long) (TASK_SIZE - dump->start_stack)) 
      >> PAGE_SHIFT;

  /* copy register contents */
  memset((void *)&dump->regs, 0, (size_t)sizeof(dump->regs));
  dump->regs.ebx = regs->ebx; 
  dump->regs.ecx = regs->ecx; 
  dump->regs.edx = regs->edx; 
  dump->regs.esi = regs->esi; 
  dump->regs.edi = regs->edi; 
  dump->regs.ebp = regs->ebp; 
  dump->regs.eax = regs->eax; 
  dump->regs.orig_eax = regs->orig_eax; 
  dump->regs.eip = regs->eip; 
  dump->regs.eflags = regs->eflags; 
  dump->regs.esp = regs->esp;
  
  dump->u_fpvalid = dump_fpu (&dump->i387);
}

/* fork/exec system calls (copied from arch/i386/kernel/process.c) */

asmlinkage int sys_fork(void)
{
        struct pt_regs *regs = &current->tss.ex_page->regs;
	return do_fork(SIGCHLD, regs->esp, regs);
}

asmlinkage int internal_sys_clone(struct pt_regs regs)
{

	unsigned long clone_flags;
	unsigned long newsp;

	clone_flags = regs.ebx;
	newsp = regs.ecx;
	if (!newsp)
		newsp = regs.esp;

	return do_fork(clone_flags, newsp, &regs);
}

/* sys_*(ebx, ecx, edx, esi, edi); */
asmlinkage int sys_clone(unsigned long clone_flags, unsigned long newsp)
{
	struct pt_regs *regs = &current->tss.ex_page->regs;

	if (!newsp)
		newsp = regs->esp;

	return do_fork(clone_flags, newsp, regs);
}

/*
 * sys_execve() executes a new program.
 */
/* sys_*(ebx, ecx, edx, esi, edi); */
asmlinkage int sys_execve(char *name, char **argv, char **envp)
{
	int error;
	char * filename;

	error = getname(name, &filename);
	if (error)
		return error;
	error = do_execve(filename, argv, envp, &current->tss.ex_page->regs);
	putname(filename);

	return error;
}

/* kernel-internal execve() */
int execve(char * file, char ** argv, char ** envp)
{
  int error;

  ASSERT(thread_equal(current->tss.user_thread_id, L4_NIL_ID));

  /* we are going to become a real user task now, so prepare a real
     pt_regs structure.
     this assumes the kernel doesn't use ex_page->regs for
     kernel-internal tasks except for clone()ing */
  current->tss.ex_page->regs = (struct pt_regs) PTREGS_INITIALIZER;

  /* we're about to exec, so get a task id now */
  if (get_new_taskno(&current->tss.user_thread_id) < 0)
    {
      printk("execve: No task no left for user\n"); 
      errno = -EBUSY;

      return -1;
    }

  /* now the fun part: we're switching to user space, so set fs to
     point to user space */
  ASSERT(get_fs() == KERNEL_DS);
  set_fs(USER_DS);

  /* do_execve() will create the user task for us in
     start_thread(). */

  error = do_execve(file, argv, envp, & current->tss.ex_page->regs);
  if (error)
    {
      /* we failed -- become a kernel thread again */
      task_no_free(current->tss.user_thread_id.id.task);
      set_fs(KERNEL_DS);
      current->tss.user_thread_id = L4_NIL_ID;

      errno = -error;

      return -1;
    }

  start_thread_really();
  task_to_proc[current->tss.user_thread_id.id.task] = current;

  /* now become a service thread */
  schedule();			/* sleep and wait for user activation */
#if 1
  enter_kdebug("kexecve: returned from schedule");
#endif
  sig_kill_received();

  /* not reached */
  enter_kdebug("not reached");
  return 0;
}

void
sig_kill_received(void)
{
#if 0
  enter_kdebug("sig_kill");
  herc_printf("sending sig_kill (%x) to %s\n",current->signal, current->comm);
#endif
  if (current->signal & (1 << (SIGKILL - 1)))
    {
      /* OK, some server thread just signaled SIGKILL */
      
      /* mask out other sigs; we don't care about them any
	 more; then just handle the signal, and we're done */
      current->signal = (1 << (SIGKILL - 1));
      do_signal(current->blocked, NULL);
      
      panic("The zombie walks after SIGKILL!!!");
    }
  enter_kdebug("sig_kill_received: no sig_kill");
}

void
print_idle_switch(struct task_struct *next)
{
  herc_printf("sys_idle: switching from %s(%d) to %s(%d)\n",
	      current->comm, current->pid,
	      next->comm, next->pid);
}

void
print_dispatch_switch(struct task_struct *next)
{
  herc_printf("dispatch: switching from %s(%d) to %s(%d)\n",
	      current->comm, current->pid,
	      next->comm, next->pid);
}

void watch_current(struct task_struct *next_current)
{
  if ((next_current->tss.kernel_stack & 0xfff) != 0xff4)
    {
      printk("proc %s strange kernel_stack, state: %lx\n", 
	     next_current->comm, next_current->tss.kernel_stack);
      if (!next_current->next_run || !next_current->prev_run)
	{
	  printk("proc %s not on runqueue, state: %lx\n", 
		 next_current->comm, next_current->state);
	}
      enter_kdebug("strange kernel stack");
    }
  if (!next_current->next_run || !next_current->prev_run)
    {
      printk("proc %s not on runqueue, state: %lx\n", 
	     next_current->comm, next_current->state);
      enter_kdebug("task not on runqueue");
    }
}
