#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stddef.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>
#include <linux/malloc.h>
#include <linux/ldt.h>
#include <linux/user.h>
#include <linux/a.out.h>
#include <linux/tty.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/config.h>
#ifdef CONFIG_APM
#include <linux/apm_bios.h>
#endif
#ifdef CONFIG_BLK_DEV_RAM
#include <linux/blk.h>
#endif
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/smp.h>


#include <l4/kdebug.h>
#include "../include/l4_memory.h"
#include "../include/drivers.h"
#include "../include/mb_info.h"
#include "../include/debug.h"

#define MAX_COLOR_MASK 0xfffc0000
#define MAX_COLORS 64
#define COLORS_TO_USE 32
 
extern l4_threadid_t root_exec_th, kernel_thread_id;
unsigned long __remap_start, __remap_src;
extern l4_threadid_t sigma0_id;
extern int sigma0_initialized;

/* common functions */
void
flush_page(unsigned long address)
{
  l4_fpage_unmap(l4_fpage(address, L4_LOG2_PAGESIZE, 0, 0).fpage, 
		 L4_FP_ALL_SPACES | L4_FP_FLUSH_PAGE);
}


/* function exceuted by root exec thread */
void 
request_physical_page_from_sigma0(unsigned long physical_page, 
				  unsigned long access, 
				  unsigned long vm_page)
{
  dword_t fpage, snd_base, error;
  l4_msgdope_t result;
#ifdef DEBUG
  herc_printf("req_phy_page: page: %lx (%s), vm_page: %lx\n",
	      physical_page, ((access == L4_WRITE_ACCESS) ? "write" : "read"),
	      vm_page);
  enter_kdebug("rpp: request_page");
#endif
  if (!sigma0_initialized)
    panic("request_physical_page_from_sigma0 not inititialized");

  if (physical_page >= root_pager_memory_end)
    enter_kdebug("remap: physical page >= memory end");

/*   herc_printf("req: phys: %lx, vm: %lx\n", physical_page, vm_page); */
/*   enter_kdebug("calling rmgr"); */
  error = l4_i386_ipc_call(sigma0_id, L4_IPC_SHORT_MSG,
			   (physical_page & ~L4_ACCESS_MASK) | access, 
			   ROOT_REQUEST_PHYSICAL_PAGE,
			   L4_IPC_MAPMSG(vm_page, L4_LOG2_PAGESIZE),
			   &fpage, &snd_base, L4_IPC_NEVER,
			   &result);
/*   herc_printf("fp: %lx, sb: %lx\n, res: %lx", fpage, snd_base, result); */
/*   enter_kdebug("rps"); */
  if (error)
    enter_kdebug("rpp: ipc error :(");
  if (!l4_ipc_fpage_received(result))
    enter_kdebug("rpp: no mapping");
#ifdef DEBUG
  enter_kdebug("rpp: request_page finished");
#endif
}

int
remap_root_page(int __dummy)
{
  int retval;
  dword_t dummy;
  l4_msgdope_t res_dope;
  int code;

  cli();
  /* copy page contents, flush page, map new page, map page to linux server */
  memcpy(__remap_src, __remap_start, 4096);
  flush_page(__remap_start);
  request_physical_page_from_sigma0(__remap_src, L4_WRITE_ACCESS, 
				    __remap_start);
/*   request_physical_page_from_sigma0(__remap_start, L4_WRITE_ACCESS,  */
/* 				    __remap_src); */
  /* request remapping and receive flex page */
  code = l4_i386_ipc_call(kernel_thread_id, 
			  L4_IPC_SHORT_FPAGE, 
			  __remap_start,
			  l4_fpage(__remap_start, L4_LOG2_PAGESIZE, 
				   L4_FPAGE_RW, L4_FPAGE_MAP).fpage, 
			  0, 
			  (dword_t *) &retval, &dummy,
			  L4_IPC_TIMEOUT(1, 5, 0, 0, 0, 0), /* snd tmo = 1s */
			  &res_dope);
  if (code)
    {
      panic("remap_root_page: call returned code 0x%x", code);
    }
  clear_bit(PG_DMA, &mem_map[MAP_NR(__remap_start)].flags);
  sti();
  return code;
}

/* functions executed by linux server */
static int 
root_task_execute_remap(int (*subroutine)(int arg), int arg)
{
  int retval;
  dword_t dummy;
  l4_msgdope_t res_dope;
  int code;
  l4_snd_fpage_t fpage;

  cli();
  /* request remapping and receive flex page */
  code = l4_i386_ipc_call(root_exec_th, 
			  0, (dword_t) subroutine, (dword_t) arg,
			  L4_IPC_MAPMSG(0, L4_WHOLE_ADDRESS_SPACE), 
			  &fpage.snd_base, &fpage.fpage.fpage,
			  L4_IPC_TIMEOUT(1, 5, 0, 0, 0, 0), /* snd tmo = 1s */
			  &res_dope);
  if (code)
    {
      panic("root_task_execute_remap(1): call returned code 0x%x", 
	    code);
    }
  if (l4_ipc_fpage_received(res_dope))
    {
      if (!l4_ipc_is_fpage_writable(fpage.fpage))
	enter_kdebug("page mapped read /*@only@*/");
    }
  else
    herc_printf("no mapping, res: %lx\n", res_dope.msgdope);

  /* send receipt and receive return code */
  code = l4_i386_ipc_call(root_exec_th, 
			  0, (dword_t) subroutine, (dword_t) arg,
			  0, (dword_t *) &retval, &dummy,
			  L4_IPC_TIMEOUT(1, 5, 0, 0, 0, 0), /* snd tmo = 1s */
			  &res_dope);
  if (code)
    {
      panic("root_task_execute_remap(2): call returned code 0x%x", code);
    }
  sti();
  return retval;
}

void
remap_kernel_area(unsigned long start, unsigned long src)
{
  int i;
  __remap_start = start;
  __remap_src = src;
  for(i=0; i< COLORS_TO_USE; i++)
    {
      root_task_execute_remap(&remap_root_page, 0);
      __remap_start+=4096;
      __remap_src+=4096;
    }
}





extern unsigned long start;
static unsigned long mem_end, remap_size,  cur, end, slot;
void
remap_kernel_memory(unsigned long *high_memory)
{
  mem_end = *high_memory & MAX_COLOR_MASK;
  remap_size = ((root_pager_memory_start-(unsigned long)&start)+
				     MAX_COLORS*4096) & MAX_COLOR_MASK;
  /*  unsigned long slots = remap_size / (4096 * 32);*/
  slot = mem_end - 2*remap_size;
  *high_memory = slot - 1;
  herc_printf("new high_mem = %lx\n", *high_memory);
  cur = (unsigned long)&start + COLORS_TO_USE * 4096;
  end = cur + remap_size;
  /*
  herc_printf("\nmem_end: %lx, high_mem: %lx,\n",
	      mem_end, *high_memory);
  herc_printf(" to be remapped: %lx-%lx (size: %lx)\n", 
	      cur, end, remap_size);
  herc_printf(" first slot: %lx\n", slot);
  */
  while(cur < end)
    {
      remap_kernel_area(cur, slot);
      cur+=MAX_COLORS*4096;
      slot+=MAX_COLORS*4096;
    } 

/*   enter_kdebug("remap_finished"); */
}

