/* $Id: debug.c,v 1.1.1.1 1999/04/06 19:21:09 yoonho Exp $ */

#include <linux/string.h>

#include "../include/debug.h"

#define SYSCALLMAX 163
#define STACK_FILL_CHAR '$'
#define DEADBEEF_SIZE 8

static char* syscall_names[] = {
"setup",
"exit",
"fork",
"read",
"write",
"open",
"close",
"waitpid",
"creat",
"link",
"unlink",
"execve",
"chdir",
"time",
"mknod",
"chmod",
"chown",
"break",
"oldstat",
"lseek",
"getpid",
"mount",
"umount",
"setuid",
"getuid",
"stime",
"ptrace",
"alarm",
"oldfstat",
"pause",
"utime",
"stty",
"gtty",
"access",
"nice",
"ftime",
"sync",
"kill",
"rename",
"mkdir",
"rmdir",
"dup",
"pipe",
"times",
"prof",
"brk",
"setgid",
"getgid",
"signal",
"geteuid",
"getegid",
"acct",
"phys",
"lock",
"ioctl",
"fcntl",
"mpx",
"setpgid",
"ulimit",
"oldolduname",
"umask",
"chroot",
"ustat",
"dup2",
"getppid",
"getpgrp",
"setsid",
"sigaction",
"sgetmask",
"ssetmask",
"setreuid",
"setregid",
"sigsuspend",
"sigpending",
"sethostname",
"setrlimit",
"getrlimit",
"getrusage",
"gettimeofday",
"settimeofday",
"getgroups",
"setgroups",
"select",
"symlink",
"oldlstat",
"readlink",
"uselib",
"swapon",
"reboot",
"readdir",
"mmap",
"munmap",
"truncate",
"ftruncate",
"fchmod",
"fchown",
"getpriority",
"setpriority",
"profil",
"statfs",
"fstatfs",
"ioperm",
"socketcall",
"syslog",
"setitimer",
"getitimer",
"stat",
"lstat",
"fstat",
"olduname",
"iopl",
"vhangup",
"idle",
"vm86",
"wait4",
"swapoff",
"sysinfo",
"ipc",
"fsync",
"sigreturn",
"clone",
"setdomainname",
"uname",
"modify_ldt",
"adjtimex",
"mprotect",
"sigprocmask",
"create_module",
"init_module",
"delete_module",
"get_kernel_syms",
"quotactl",
"getpgid",
"fchdir",
"bdflush",
"sysfs",
"personality",
"afs_syscall",
"setfsuid",
"setfsgid",
"_llseek",
"getdents",
"_newselect",
"flock",
"msync",
"readv",
"writev",
"getsid",
"fdatasync",
"_sysctl",
"mlock",
"munlock",
"mlockall",
"munlockall",
"sched_setparam",
"sched_getparam",
"sched_setscheduler",
"sched_getscheduler",
"sched_yield",
"sched_get_priority_max",
"sched_get_priority_min",
"sched_rr_get_interval",
"nanosleep",
"mremap"
};

static char * signalnames[] = {
"NoSIG",
"SIGHUP",
"SIGINT",		 
"SIGQUIT",		 
"SIGILL",	 
"SIGTRAP",		 
"SIGABRT",		 
"SIGBUS",	 
"SIGFPE",	 
"SIGKILL",	 
"SIGUSR1",	
"SIGSEGV",	
"SIGUSR2",	
"SIGPIPE",	
"SIGALRM",	
"SIGTERM",	
"SIGSTKFLT",	
"SIGCHLD",	
"SIGCONT",	
"SIGSTOP",	
"SIGTSTP",
"SIGTTIN",
"SIGTTOU",
"SIGURG",
"SIGXCPU",
"SIGXFSZ",
"SIGVTALRM",
"SIGPROF",	
"SIGWINCH",
"SIGIO",
"SIGPWR",
"SIGUNUSED"
};


char*
get_signal_name(unsigned no)
{
  if(no>32)
    return (char*)0;

  return signalnames[no];
}

char*
get_syscall_name(unsigned no)
{
  if(no>SYSCALLMAX) 
    return ((char*) 0);
  
  return syscall_names[no];
}

int
stack_fill(char * stack_top, char * stack_bottom)
{
  if(stack_top <= stack_bottom)
    return 0;
 
  /* account for deadbeef */
  stack_bottom += DEADBEEF_SIZE; 
 
  memset(stack_bottom,STACK_FILL_CHAR,stack_top-stack_bottom);
  return 1;
}

int 
stack_used(char * stack_top, char * stack_bottom)
{
  if(stack_top <= stack_bottom)
    return 0;

  /* account for deadbeef */
  stack_bottom += DEADBEEF_SIZE; 

  while(*stack_bottom == STACK_FILL_CHAR && stack_top > stack_bottom)
    ++stack_bottom;
  
  return stack_top-stack_bottom; 
}
