#include <stdarg.h>
#include <asm/system.h>
#include <linux/kernel.h>

#include "../include/debug.h"
#include "../include/lock.h"

#include <l4/kdebug.h>

simple_lock_t herc_lock;

static char herc_buf[2048];
asmlinkage int herc_printf(const char *fmt, ...)
{
  va_list args;
  int i;
/*   long flags; */
  char *p, *buf_end;

  if (simple_try_lock(&herc_lock))
    {
      
      /*   save_flags(flags); */
      /*   cli(); */
      va_start(args, fmt);
      i = vsprintf(herc_buf, fmt, args); /* hopefully i < sizeof(herc_buf)-4 */
      
      if (!(i < sizeof(herc_buf)))
	enter_kdebug("herc_printf buffer overflow");
      
      buf_end = herc_buf + i;
      va_end(args);
      for (p = herc_buf; p < buf_end; p++) {
	if (*p == '\n')
	  {
	    outchar('\r');
	    outchar('\n');
	  }
	else
	  outchar(*p);
      }
      simple_unlock(&herc_lock);
      /*   restore_flags(flags); */
      return i;
    }
  else
    {
      kd_display("herc_print locked\\r\\n");
      return 0;
    }
}
