#include <asm/segment.h>
#include <asm/page.h>

#include "../include/l4_memory.h"

#define MIN(a,b) (((a)<(b))?(a):(b))

#undef DEBUG_PUT
#ifdef DEBUG_PUT

#define BUILD_USER_ACCESS_PF(name, type)				      \
void									      \
put_user_##name##_pf(unsigned  type val, type * address, pte_t pte)	      \
{									      \
  unsigned long page, offset;						      \
  printk("(%x.%x)put_user_"str(name)"_pf called for addr: %x, pte: %x\n",     \
         l4_myself().id.task, l4_myself().id.lthread,  			      \
	 (unsigned)address, (unsigned)pte_val(pte)); 			      \
  request_page_writeable((unsigned long)address, pte);			      \
  macro_parse_ptabs_write(address, page, offset);			      \
  if (page)								      \
    *((unsigned type *)(page + offset)) = val;				      \
  else									      \
    panic("No page in put_user_"str(name)"_pf\n"); 			      \
}									      \
unsigned type 								      \
get_user_##name##_pf(type * address)					      \
{									      \
  unsigned long page, offset;						      \
  printk("(%x.%x)get_user_"str(name)"_pf called for addr: %x\n", 	      \
         l4_myself().id.task, l4_myself().id.lthread,  			      \
         (unsigned)address); 						      \
  request_page_readable((unsigned long)address);			      \
  macro_parse_ptabs_read(address, page, offset);			      \
  if (page)								      \
    return *((unsigned type *)(page + offset));				      \
  else									      \
    panic("No page in get_user_"str(name)"_pf\n"); 			      \
}

BUILD_USER_ACCESS_PF(byte, char)
BUILD_USER_ACCESS_PF(word, short)
BUILD_USER_ACCESS_PF(long, long)

#ifndef BUILD_REALLY 
#undef  BUILD_USER_ACCESS

#define BUILD_USER_ACCESS(name, type)					      \
void									      \
put_user_##name(unsigned  type val, type * address)			      \
{									      \
  unsigned long page, offset;						      \
  printk("(%x.%x)put_user_"str(name)" called from : %x, for addr: %x\n",      \
         l4_myself().id.task, l4_myself().id.lthread,  			      \
         __builtin_return_address(0), (unsigned)address);		      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
         (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_write(address, page, offset);			      \
      if (page)								      \
	*((unsigned type *)(page + offset)) = val;			      \
      else								      \
	put_user_##name##_pf(val, address, __pte(offset));		      \
    }			 						      \
  else									      \
    put_user_##name##_slow_path(val, (unsigned long) address);		      \
}									      \
unsigned type 								      \
get_user_##name(type * address)						      \
{									      \
  unsigned long page, offset;						      \
  printk("(%x.%x)get_user_"str(name)" called from : %x, for addr: %x\n",      \
         l4_myself().id.task, l4_myself().id.lthread,  			      \
         __builtin_return_address(0), (unsigned)address);		      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
	 (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_read(address, page, offset);			      \
      if (page)								      \
	return *((unsigned type *)(page + offset));			      \
      else								      \
	return get_user_##name##_pf(address);				      \
    }									      \
  else									      \
    return get_user_##name##_slow_path((unsigned long)address);		      \
}


BUILD_USER_ACCESS(byte, char)
BUILD_USER_ACCESS(word, short)
BUILD_USER_ACCESS(long, long)
#endif

#else

#define BUILD_USER_ACCESS_PF(name, type)				      \
void									      \
put_user_##name##_pf(unsigned  type val, type * address, pte_t pte)	      \
{									      \
  unsigned long page, offset;						      \
  request_page_writeable((unsigned long)address, pte);			      \
  macro_parse_ptabs_write(address, page, offset);			      \
  if (page)								      \
    *((unsigned type *)(page + offset)) = val;				      \
  else									      \
    panic("No page in put_user_"str(name)"_pf\n"); 			      \
}									      \
unsigned type 								      \
get_user_##name##_pf(type * address)					      \
{									      \
  unsigned long page, offset;						      \
  request_page_readable((unsigned long)address);			      \
  macro_parse_ptabs_read(address, page, offset);			      \
  if (page)								      \
    return *((unsigned type *)(page + offset));				      \
  else									      \
    panic("No page in get_user_"str(name)"_pf\n"); 			      \
}

BUILD_USER_ACCESS_PF(byte, char)
BUILD_USER_ACCESS_PF(word, short)
BUILD_USER_ACCESS_PF(long, long)

#ifndef BUILD_REALLY 
#undef  BUILD_USER_ACCESS

#define BUILD_USER_ACCESS(name, type)					      \
void									      \
put_user_##name(unsigned  type val, type * address)			      \
{									      \
  unsigned long page, offset;						      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
         (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_write(address, page, offset);			      \
      if (page)								      \
	*((unsigned type *)(page + offset)) = val;			      \
      else								      \
	put_user_##name##_pf(val, address, __pte(offset));		      \
    }			 						      \
  else									      \
    put_user_##name##_slow_path(val, (unsigned long) address);		      \
}									      \
unsigned type 								      \
get_user_##name(type * address)						      \
{									      \
  unsigned long page, offset;						      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
	 (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_read(address, page, offset);			      \
      if (page)								      \
	return *((unsigned type *)(page + offset));			      \
      else								      \
	return get_user_##name##_pf(address);				      \
    }									      \
  else									      \
    return get_user_##name##_slow_path((unsigned long)address);		      \
}


BUILD_USER_ACCESS(byte, char)
BUILD_USER_ACCESS(word, short)
BUILD_USER_ACCESS(long, long)

#endif
#endif

/* void */
/* put_user_byte_slow_path(unsigned long address, unsigned char val) */
/* { */
/*   put_user_byte(address, val); */
/*   put_user_byte(address + 1, val >> 8); */
/* } */

/* unsigned short  */
/* get_user_byte_slow_path(unsigned long address) */
/* { */
/*   return get_user_byte(address) + (get_user_byte(address + 1) << 8); */
/* } */

void
put_user_word_slow_path(unsigned short val, unsigned long address)
{
  put_user_byte(val, (unsigned char *)address);
  put_user_byte(val >> 8, (unsigned char *)(address + 1));
}

unsigned short 
get_user_word_slow_path(unsigned long address)
{
  return get_user_byte((unsigned char *)address) + 
    (get_user_byte((unsigned char *)address + 1) << 8);
}

void
put_user_long_slow_path(unsigned long val, unsigned long address)
{
  switch (address &3) 
    {
    case 1:
    case 3:
      put_user_byte(val, (unsigned char *)address);
      put_user_byte(val >> 8, (unsigned char *)(address+1));
      put_user_word(val >> 16, (unsigned short *)(address+2));
      break;
    case 2:
      put_user_word(val, (unsigned short *)address);
      put_user_word(val >> 16, (unsigned short *)(address+2));
      break;
    default: 
      bad_user_access_length();
    }
}

unsigned long 
get_user_long_slow_path(unsigned long address)
{
  switch (address &3) 
    {
    case 1:
    case 3:
      return get_user_byte((unsigned char *)address) +
	(get_user_byte((unsigned char *)(address+1)) << 8) +
	(get_user_word((unsigned short *)(address+2)) << 16);
    case 2:
      return get_user_word((unsigned short *)(address)) + 
	(get_user_word((unsigned short *)(address+2)) << 16);
    default: 
      bad_user_access_length();
      return 0;
    }
}
void set_fs(unsigned short val)
{
  current->tss.fs = val << 16;
  if ((val << 16) == KERNEL_DS)
    {
#ifdef DEBUG_SET_FS
      printk("(%x:%x)set_fs: called from:%lx, fs = KERNEL_DS(__pdir=%lx)\n",  
	     l4_myself().id.task, l4_myself().id.lthread, 
	     __builtin_return_address(0), (unsigned long)swapper_pg_dir);
#endif 
      current_pdir = (unsigned long)swapper_pg_dir;
    }
  else
    {
#ifdef DEBUG_SET_FS
      printk("(%x:%x)set_fs: called from:%lx, fs = USER_DS(__pdir=%lx)\n",  
	     l4_myself().id.task, l4_myself().id.lthread, 
	     __builtin_return_address(0), 
	     (unsigned long)current->tss.page_dir);
#endif 
      current_pdir = (unsigned long)current->tss.page_dir;
    }
}

unsigned char 
blah(unsigned long address)
{
  char *c=(char *)100;
  short *s=(short *)200;
  long *l=(long *)300;

  put_user(5, (unsigned long *)&current->tss);
  put_user(5, c);
  put_user(5, s);
  put_user(5, l);

  return get_user_byte(c);
}
