/*
 *	The sound core exports the following symbols to the rest of
 *	modulespace.
 *
 *	(C) Copyright 1997 	Alan Cox, Licensed under the GNU GPL
 */
 
#include <linux/config.h>
#include <linux/module.h>
#include "sound_config.h"
#define _MIDI_SYNTH_C_
#include "midi_synth.h"
#include <linux/notifier.h>
#include "sound_firmware.h"

extern struct notifier_block *sound_locker;

static struct symbol_table sound_syms = {
#include <linux/symtab_begin.h>
	X(mixer_devs),
	X(audio_devs),
	X(num_audiodevs),
	
	X(note_to_freq),
	X(pmgr_inform),
	X(compute_finetune),
	X(seq_copy_to_input),
	X(sequencer_timer),

	X(sound_install_audiodrv),
	X(sound_install_mixer),
	X(sound_alloc_dma),
	X(sound_free_dma),
	X(snd_ioctl_return),
	X(snd_set_irq_handler),
	X(snd_release_irq),
	X(sound_alloc_audiodev),
	X(sound_alloc_mididev),
	X(sound_alloc_mixerdev),
	X(sound_alloc_timerdev),
	X(sound_alloc_synthdev),
	X(sound_unload_audiodev),
	X(sound_unload_mididev),
	X(sound_unload_mixerdev),
	X(sound_unload_timerdev),
	X(sound_unload_synthdev),
	
	X(DMAbuf_start_dma),
	X(DMAbuf_inputintr),
	X(DMAbuf_outputintr),

	X(conf_printf2),

	X(sound_timer_init),
	X(sound_timer_interrupt),	
	X(sound_timer_syncinterval),

	/* Locking */
	X(sound_locker),

	/* Firmware */
	X(mod_firmware_load),	
	/* MIDI symbols */
	X(midi_devs),
	X(num_midis),
	X(synth_devs),
	X(num_synths),
	
	X(do_midi_msg),
	X(midi_synth_open),
	X(midi_synth_close),
	X(midi_synth_ioctl),
	X(midi_synth_kill_note),
	X(midi_synth_start_note),
	X(midi_synth_set_instr),
	X(midi_synth_reset),
	X(midi_synth_hw_control),
	X(midi_synth_load_patch),
	X(midi_synth_aftertouch),
	X(midi_synth_controller),
	X(midi_synth_panning),
	X(midi_synth_patchmgr),
	X(midi_synth_bender),
	X(midi_synth_setup_voice),
	X(midi_synth_send_sysex),
	X(midi_synth_bender),
	
#include <linux/symtab_end.h>
};

void export_sound_symbols(void)
{
	register_symtab(&sound_syms);
#ifdef CONFIG_AD1848
	export_ad1848_syms();
#endif
#ifdef CONFIG_YM3812
	export_opl3_syms();
#endif
#ifdef CONFIG_SBDSP_EXPORT
	export_sb_syms();
#endif
#ifdef CONFIG_UART401
	export_uart401_syms();
#endif
}

