/* $Id: processor.h,v 1.1.1.1 1999/04/06 19:28:00 yoonho Exp $ */

#ifndef __ASM_L4_I386_PROCESSOR_H
#define __ASM_L4_I386_PROCESSOR_H

#ifndef __ASSEMBLY__

#include <l4/types.h>
#include <l4/syscalls.h>

#include "../../arch/l4-i386/include/locktypes.h" /* struct ConditionTag */
#include "../../arch/l4-i386/include/config.h"    /* TASK_SIZE */

#include <linux/ptrace.h>	/* struct ptregs */

/* supported bus systems */
extern int EISA_bus;
#define MCA_bus 0
#define MCA_bus__is_a_macro	/* for versions in ksyms.c */

/* bug flags (tested for in <asm-l4-i386/bugs.h> */
extern int fdiv_bug;

#define wp_works_ok 1
#define wp_works_ok__is_a_macro /* for versions in ksyms.c */

/* processor info */
extern char x86;		/* set by chead.c */
extern char hard_math;

/* XXX - someone must fill these */
extern char x86_vendor_id[13];
extern char x86_model;          /* lower 4 bits */
extern char x86_mask;           /* lower 4 bits */
extern int  x86_capability;     /* field of flags */

/* kernel-thread info , some more info needed for Linux on L4*/
struct exclusive_page_tag;

struct thread_struct {
  simple_lock_t under_kernel_control; /* status of linux task ( needed
					 for signal delivery ) */
  pgd_t *page_dir;		/* needed to find page directory of process */
  unsigned long kernel_sp;
  unsigned long kernel_stack;
  struct exclusive_page_tag *ex_page; /* excl_page.h */
  struct wait_queue *unselect_wait_queue; /* event we are waiting on */
  l4_threadid_t user_thread_id;	/* Id of thread 0 (signalling thread) */
  unsigned long fs;
  unsigned long flags;
  unsigned long page_fault_addr;
};

extern struct thread_struct *current_tss;

#define INIT_TSS { 1, swapper_pg_dir, 0, 0, 0, 0, L4_NIL_ID,   \
		     KERNEL_DS, 0, 0 }

/* XXX - what is this used for? */
#define INIT_MMAP { &init_mm, 0, USER_VM_OFFSET, PAGE_SHARED, VM_READ | VM_WRITE | VM_EXEC }

/* alloc/free kernel stack for a task */
#define alloc_kernel_stack()    get_free_page(GFP_KERNEL)
#define free_kernel_stack(page) free_page((page))

/* start a new user thread */
void start_thread(struct pt_regs * regs, unsigned long eip, unsigned long esp);

static inline unsigned long thread_saved_pc(struct thread_struct *t)
{
  return 0;			/* XXX, but used for printk info only */
}
#endif /* __ASSEMBLY__ */
/* ugly, ugly, ugly. I will check this value at kernel startup just to
   be shure it hasn't changed due to changes in struct task_struct */
#define OFFS_TSS 536 
#define OFFS_UNDER_KERNEL_CONTROL 	536 /* (OFFS_TSS + 0) */
#define OFFS_PAGEDIR 			540 /* (OFFS_TSS + 4) */
#define OFFS_KERNEL_ESP 		544 /* (OFFS_TSS + 8) */
#define OFFS_KERNEL_STACK 		548 /* (OFFS_TSS + 12) */
#define OFFS_EXCLUSIV_PAGE 		552 /* (OFFS_TSS + 16) */
#endif /* ! __ASM_L4_I386_PROCESSOR_H */
