/* $Id: ptrace.h,v 1.1.1.1 1999/04/06 19:28:00 yoonho Exp $ */

#ifndef __ASM_L4_I386_PTRACE_H
#define __ASM_L4_I386_PTRACE_H

/* XXX */

/* XXX Reintroduce old register offset to be able to run old programs
 * XXX unmodified */

#define OLD_EBX 0
#define OLD_ECX 1
#define OLD_EDX 2
#define OLD_ESI 3
#define OLD_EDI 4
#define OLD_EBP 5
#define OLD_EAX 6
#define OLD_DS 7
#define OLD_ES 8
#define OLD_FS 9
#define OLD_GS 10
#define OLD_ORIG_EAX 11
#define OLD_EIP 12
#define OLD_CS  13
#define OLD_EFL 14
#define OLD_UESP 15
#define OLD_SS   16

/* adapted to changed tss structure below! */
#define OFFS_EBX 0
#define OFFS_ECX 4
#define OFFS_EDX 8
#define OFFS_ESI 12
#define OFFS_EDI 16
#define OFFS_EBP 20
#define OFFS_EAX 24
/* no ds,es,fs,gs in L4 */
#define OFFS_ORIG_EAX 28
#define OFFS_EIP 32
#define OFFS_CS 36
#define OFFS_EFLAGS 40
#define OFFS_UESP 44
/* no ss in L4 */
#define PTREGS_SIZE 48

/* this struct defines the way the registers are stored on the 
   stack during a system call. */

#ifndef __ASSEMBLY__

struct pt_regs {
	long ebx;
	long ecx;
	long edx;
	long esi;
	long edi;
	long ebp;
	long eax;
#if 0
	unsigned short ds, __dsu;
	unsigned short es, __esu;
	unsigned short fs, __fsu;
	unsigned short gs, __gsu;
#endif
	long orig_eax;
	long eip;
	unsigned short cs, __csu;
	long eflags;
	long esp;
#if 0
	unsigned short ss, __ssu;
#endif
};
/* XXX Hardcoded cs, needs to be fixed */
#define PTREGS_INITIALIZER { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1b, 0, 0x200, 0}

#ifdef __KERNEL__
#define user_mode(regs) ((VM_MASK & (regs)->eflags) || (3 & (regs)->cs))
#define instruction_pointer(regs) ((regs)->eip)
extern void show_regs(struct pt_regs *);

/* this struct defines the way the registers are stored on the stack
   during a system call on Linux/i386. We have to keep a copy around
   to be able to imitate some i386 data structures needed to ensure
   ABI compatibility */

struct linux_i386_pt_regs {
	long ebx;
	long ecx;
	long edx;
	long esi;
	long edi;
	long ebp;
	long eax;
	unsigned short ds, __dsu;
	unsigned short es, __esu;
	unsigned short fs, __fsu;
	unsigned short gs, __gsu;
	long orig_eax;
	long eip;
	unsigned short cs, __csu;
	long eflags;
	long esp;
	unsigned short ss, __ssu;
};



#endif

#endif /* __ASSEMBLY__ */

#endif /* ! __ASM_L4_I386_PTRACE_H */

