/* $Id: system.h,v 1.1.1.1 1999/04/06 19:28:00 yoonho Exp $ */

#ifndef __ASM_L4_I386_SYSTEM_H
#define __ASM_L4_I386_SYSTEM_H
#include "../../arch/l4-i386/include/config.h"
#include "../../arch/l4-i386/include/lock.h"
#define nop() __asm__ __volatile__ ("nop")

#define xchg(ptr,x) ((__typeof__(*(ptr)))__xchg((unsigned long)(x),(ptr),sizeof(*(ptr))))
#define tas(ptr) (xchg((ptr),1))

struct __xchg_dummy { unsigned long a[100]; };
#define __xg(x) ((struct __xchg_dummy *)(x))

static inline unsigned long __xchg(unsigned long x, void * ptr, int size)
{
	switch (size) {
		case 1:
			__asm__("xchgb %b0,%1"
				:"=&q" (x), "=m" (*__xg(ptr))
				:"0" (x), "m" (*__xg(ptr)));
			break;
		case 2:
			__asm__("xchgw %w0,%1"
				:"=&r" (x), "=m" (*__xg(ptr))
				:"0" (x), "m" (*__xg(ptr)));
			break;
		case 4:
			__asm__("xchgl %0,%1"
				:"=&r" (x), "=m" (*__xg(ptr))
				:"0" (x), "m" (*__xg(ptr)));
			break;
	}
	return x;
}

#define mb()  __asm__ __volatile__ (""   : : :"memory")
#define __sti() __asm__ __volatile__ ("sti": : :"memory")
#define __cli() __asm__ __volatile__ ("cli": : :"memory")
#define __save_flags(x) \
__asm__ __volatile__("pushfl ; popl %0":"=g" (x): /* no input */ :"memory")
#define __restore_flags(x) \
__asm__ __volatile__("pushl %0 ; popfl": /* no output */ :"g" (x):"memory")

/* the following macros expand to the real thing only if !TAME_SERVER. */
#ifndef TAME_SERVER
# define __cli_tame() __cli()
# define __sti_tame() __sti()
# define __save_flags_tame(x) __save_flags(x)
# define __restore_flags_tame(x) __restore_flags(x)
# define __cli_if_tame()
# define __sti_if_tame()
#else
# define __cli_tame()
# define __sti_tame()
# define __save_flags_tame(x) ((x) = 0)
# define __restore_flags_tame(x) 
# define __cli_if_tame() __cli()
# define __sti_if_tame() __sti()
#endif

#ifndef IRQ_LOCK

#define sti() __sti()
#define cli() __cli()
#define save_flags(x) __save_flags(x)
#define restore_flags(x) __restore_flags(x)

#else /* IRQ_LOCK */

# ifdef TAME_SERVER

/* tame servers protect short critical regions using this lock: */

# if 0 /* spin-locks don't work well with prios */
extern simple_lock_t irq_queue_lock;
#  define __cli_q() simple_lock(&irq_queue_lock)
#  define __cli_q_and_cli() __cli_q()
#  define __sti_q() simple_unlock(&irq_queue_lock)
#  define __sti_q_not_sti() __sti_q()
# else /* for now, use the real "cli" for short-term locking */
#  define __cli_q() __cli()
#  define __cli_q_and_cli() __cli_q()
#  define __sti_q() __sti()
#  define __sti_q_not_sti() __sti_q()
# endif

# else /* !TAME_SERVER */

# define __cli_q() __cli()
# define __cli_q_and_cli() __cli()
# define __sti_q() __sti()
# define __sti_q_not_sti() 

# endif /* !TAME_SERVER */

/* cli lock implementation follows */

struct next_locker
{
  l4_threadid_t id;
  int queued;
  struct next_locker *next;
};

extern l4_threadid_t interrupt_lock_owner;

extern struct next_locker *int_lock_queue_head;
extern struct next_locker *int_lock_queue_tail;

#define cli() do { __new_short_cli(); mb(); } while (0) 
extern void __new_cli(void);

#define sti() do { mb(); __new_short_sti(); } while (0)
extern void __new_sti(void);

#define save_flags(x) __new_save_flags((unsigned long *) &x)
extern void __new_save_flags(unsigned long *flags);

#define restore_flags(x) do { mb(); __new_restore_flags(x); mb(); } while (0)
extern void __new_restore_flags(unsigned long flags);

/* the above few functions can be inlined depending on the following
   settings: (set to 0 if you don't desire a function to be inlined) */

#define INLINED_CLI 1
#define INLINED_STI 0
#define INLINED_SAVE_FLAGS 1
#define INLINED_RESTORE_FLAGS 0

/* properly conditionalize inlining */

#define __do_inline(prototype, body...) extern inline prototype body
#ifndef __IRQ_DEFINE__		/* header declaration only */
# define __dont_inline(prototype, body...) prototype ;
#else
# define __dont_inline(prototype, body...) prototype body
#endif

#define __maybe_inline_1(prototype, body...) __do_inline(prototype, body)
#define __maybe_inline_0(prototype, body...) __dont_inline(prototype, body)

#define __maybe_inline(bool, prototype, body...) \
  __maybe_inline__(bool, prototype, body) /* expand macro args */
#define __maybe_inline__(bool, prototype, body...) \
  __maybe_inline_##bool(prototype, body)

__maybe_inline(INLINED_CLI,
void __new_short_cli(void),
{
  __cli_q_and_cli();		/* starts critical section */
  if (! lock_int_lock())
    __new_cli();		/* this will also free the queue lock */
  else
    __sti_q_not_sti();
})

__maybe_inline(INLINED_STI,
void __new_short_sti(void),
{
  if (! holding_int_lock())
    return;

  __cli_q();			/* starts critical section */

  if (int_lock_queue_head)
    {
      /* dequeue thread waiting for lock, if any */
      __new_sti();
    }
  else
    {
      interrupt_lock_owner = L4_INVALID_ID;
    }

  __sti_q();
})

__maybe_inline(INLINED_SAVE_FLAGS,
void __new_save_flags(unsigned long *flags),
{
  __save_flags_tame(*flags);
  if (holding_int_lock())
    {
      *flags &= ~ 0x200;	/* clear irq enable bit */
    }
  else
    {
      *flags |= 0x200;		/* set irq enable bit */
    }
})

__maybe_inline(INLINED_RESTORE_FLAGS,
void __new_restore_flags(unsigned long flags),
{
  if (holding_int_lock())
    {
      if (flags & 0x200)
	{
	  /* sti() */
	  __cli_q();		/* starts critical section */
	  if (int_lock_queue_head)
	    {
	      /* dequeue thread waiting for lock, if any */
	      __new_sti();
	    }
	  else
	    {
	      interrupt_lock_owner = L4_INVALID_ID;
	    }
	  __sti_q();
	}
    }
  else
    {				/* ! cli */
      if (~flags & 0x200)
	__new_short_cli();
    }
  __restore_flags_tame(flags);	/* restore the other flags */
})

#endif /* IRQ_LOCK */

#define iret() __asm__ __volatile__ ("iret": : :"memory")

#define _set_gate(gate_addr,type,dpl,addr) \
__asm__ __volatile__ ("movw %%dx,%%ax\n\t" \
	"movw %2,%%dx\n\t" \
	"movl %%eax,%0\n\t" \
	"movl %%edx,%1" \
	:"=m" (*((long *) (gate_addr))), \
	 "=m" (*(1+(long *) (gate_addr))) \
	:"i" ((short) (0x8000+(dpl<<13)+(type<<8))), \
	 "d" ((char *) (addr)),"a" (KERNEL_CS << 16) \
	:"ax","dx")

#define set_intr_gate(n,addr) \
	_set_gate(&idt[n],14,0,addr)

#define set_trap_gate(n,addr) \
	_set_gate(&idt[n],15,0,addr)

#define set_system_gate(n,addr) \
	_set_gate(&idt[n],15,3,addr)

#define set_call_gate(a,addr) \
	_set_gate(a,12,3,addr)

/*
 * disable hlt during certain critical i/o operations
 */
#if 0				/* XXX */
#define HAVE_DISABLE_HLT
void disable_hlt(void);
void enable_hlt(void);
#endif

#endif /* ! __ASM_L4_I386_SYSTEM_H */

#ifndef __ASM_L4_I386_SYSTEM_H_NEEDS_SCHED_H

/* <linux/sched.h> and <asm/segment.h> included successfully? */
/* (XXX ugly hack) */
#if defined(for_each_task) && defined(KERNEL_DS)

#define __ASM_L4_I386_SYSTEM_H_NEEDS_SCHED_H

/* From asm-i386/system.h */
#define FIRST_TSS_ENTRY 8
#define _TSS(n) ((((unsigned long) n)<<4)+(FIRST_TSS_ENTRY<<3))

static inline void switch_to(struct task_struct *prev, 
			     struct task_struct *next)
{
  current = next;
  current_pdir = (unsigned long) 
    ((get_fs() == KERNEL_DS) ? swapper_pg_dir : next->tss.page_dir);
  /* we need to make sure this works with and without
     -fomit-frame-pointer; that's why we save %epb on the stack */
  __asm__ __volatile__
    ("pushl %%ebp
      pushl $1f
      movl %%esp, (%0)
      movl (%1), %%esp
      ret
1:    popl %%ebp"
     : /* no output */
     : "r" (& prev->tss.kernel_sp), "r" (& next->tss.kernel_sp)
     : "memory", "eax", "ebx", "ecx", "edx", "esi", "edi"
       /* force everything in memory */
     );
}

#define _set_base(addr,base) \
__asm__("movw %%dx,%0\n\t" \
        "rorl $16,%%edx\n\t" \
        "movb %%dl,%1\n\t" \
        "movb %%dh,%2" \
        : /* no output */ \
        :"m" (*((addr)+2)), \
         "m" (*((addr)+4)), \
         "m" (*((addr)+7)), \
         "d" (base) \
        :"dx")

#define _set_limit(addr,limit) \
__asm__("movw %%dx,%0\n\t" \
        "rorl $16,%%edx\n\t" \
        "movb %1,%%dh\n\t" \
        "andb $0xf0,%%dh\n\t" \
        "orb %%dh,%%dl\n\t" \
        "movb %%dl,%1" \
        : /* no output */ \
        :"m" (*(addr)), \
         "m" (*((addr)+6)), \
         "d" (limit) \
        :"dx")

#define set_base(ldt,base) _set_base( ((char *)&(ldt)) , base )
#define set_limit(ldt,limit) _set_limit( ((char *)&(ldt)) , (limit-1)>>12 )

#endif /* for_each_task */
#endif /* ! __ASM_L4_I386_SYSTEM_H_NEEDS_SCHED_H */
