/* $Id: int_entry.S,v 1.3 1999/05/25 17:23:27 volkmar Exp $
	movl 	PTREGS_ADDRESS+(UESP*4),%esp
generate uniform stack layout before calling exception handlers
(some have an error code on the stack, some don't)

*/

#include <asm/ptrace.h> /* ptregs , offsets */
#include "../include/shared_data.h"
#include "../include/perform.h"
#include "../include/gasp.h"	
#include <linux/linkage.h>
#include <linux/config.h>

#ifdef __X_ADAPTION__
#include <l4/xadaption.h>
#else
#define ASM_FromLId
#define ASM_ToLId
#endif

/* #define MEASURE_SYSCALL_PATH */

#ifdef __i486__
#define ALIGN_TEXT	.align	4,0x90
#else
#define ALIGN_TEXT	.align	2,0x90
#endif

#define EMU_IDT_BIT		(0x2)
#define EMU_ERROR_MASK		(0xffff)
#define EMU_SYS_CALL_ENTRY	(0x80)	
#define EMU_SYS_CALL		((EMU_SYS_CALL_ENTRY << 3) + EMU_IDT_BIT) 
#define ENOSYS			38  
#define CF_MASK			0x00000001	 	

#define EMU_TASK_MASK 0x0ffe0000

#define __label_name(x) x
#define acquire_lock_label_name(x) __label_name(x)__acquire_emulib_lock
#define locked_label_name(x) __label_name(x)__emulib_locked
#define retry_label_name(x) __label_name(x)__retry


#define LOCK_EMU_LIB(case)			\
acquire_lock_label_name(case):			\
						\
retry_label_name(case):				\
	btsl	$(EMULIB_LOCK_BIT), EMU_LOCAL_LOCK_ADDRESS;	\
	jc      locked_label_name(case);	\
	
#define EMULIB_LOCKED(case)			\
locked_label_name(case):			\
	pushl	%eax;				\
	pushl	%ebx;				\
	pushl	%ecx;				\
	pushl	%edx;				\
	pushl	%esi;				\
	pushl	%edi;				\
	pushl	%ebp;				\
						\
	xor	%esi, %esi;			\
	int	$0x33;				\
						\
	popl	%ebp;				\
    	popl	%edi;				\
	popl	%esi;				\
	popl	%edx;			        \
	popl	%ecx;				\
	popl	%ebx;				\
	popl	%eax;				\
						\
	jmp	retry_label_name(case);

.file "int_entry.S"
.text

		
/* .globl	_handle_generalized_exception */
ENTRY(real_sys_call)

	LOCK_EMU_LIB(__real_sys_call)
__real_sys_call:
    	movl	%ecx,PTREGS_ADDRESS+(ECX*4)
	popl	%ecx				/* get return address	*/

    	movl	%eax,PTREGS_ADDRESS+(ORIG_EAX*4)
	movl 	%esp,PTREGS_ADDRESS+(UESP*4)	/* save esp */

    	movl	%ecx, PTREGS_ADDRESS+(EIP*4)	/* save eip		*/
    	leal	PTREGS_ADDRESS+(EFL*4), %esp

	clc					/* clear carry		*/
    	movl 	%ebx,PTREGS_ADDRESS+(EBX*4)

      	movl	%edx,PTREGS_ADDRESS+(EDX*4)
      	movl	$-ENOSYS, PTREGS_ADDRESS+(EAX*4)

    	movl	%esi,PTREGS_ADDRESS+(ESI*4)
      	movl 	%edi,PTREGS_ADDRESS+(EDI*4)

	pushfl					/* save flags */
	movl	%ebp,PTREGS_ADDRESS+(EBP*4)
	
	movl	%eax,%ebx

#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low paort of time stamp reg */
	movl	%eax, EMULIB_START_ADDRESS
#endif
	movl	$EMULIB_SYSCALL, %edx
	movl	KERNEL_ID_ADDRESS, %esi
	movl	KERNEL_ID_ADDRESS+4, %edi

    
    	xorl	%eax, %eax
	xorl	%ecx, %ecx
	xorl	%ebp, %ebp

#ifdef DEBUG_IPC
	movl	KERNEL_ID_ADDRESS+8, %ebx
#endif
	ASM_ToLId	
	int	$0x30
	ASM_FromLId
	
#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low paort of time stamp reg */
	movl	%eax, EMULIB_STOP_ADDRESS
#endif
/* restore_regs function.
   restores content of registers from saved copy within
   exclusive page and uses a previously set up stack frame to return
*/
/*
 * write everything back from ptregs to registers
 * and simulate iret. Note that return value from syscall
 * is in ptregs.eax!
 * esp is set back to user esp (saved in ptregs)
 */

__real_restore_regs:	

 	movl	PTREGS_ADDRESS+(UESP*4), %esp
 	movl	PTREGS_ADDRESS+(EFL*4), %eax

    	movl	PTREGS_ADDRESS+(ECX*4),%ecx
    	movl	PTREGS_ADDRESS+(EDX*4),%edx

    	movl	PTREGS_ADDRESS+(ESI*4),%esi
    	movl 	PTREGS_ADDRESS+(EDI*4),%edi

    	movl	PTREGS_ADDRESS+(EBP*4),%ebp

	pushl	%eax
	pushl	%cs
	
 	movl	PTREGS_ADDRESS+(EIP*4), %eax
	movl 	PTREGS_ADDRESS+(EBX*4),%ebx

 	pushl	%eax
 	movl	PTREGS_ADDRESS+(EAX*4),%eax

	movl	$0,EMU_LOCAL_LOCK_ADDRESS

	iret

    
/* general protection */
ENTRY(entry13)

	LOCK_EMU_LIB(__sys_call)
__sys_call:			
	movl	%eax,PTREGS_ADDRESS+(ORIG_EAX*4)
	movl 	%ebx,PTREGS_ADDRESS+(EBX*4)

	movl	%eax,%ebx

    
	movl	(%esp),%eax			/* get error code */	
	movl	%ecx,PTREGS_ADDRESS+(ECX*4)

	/* check whether it is an idt error raised by 
	   int 0x80 or a normal exception */
	andw	$EMU_ERROR_MASK, %ax
	movl	%edx,PTREGS_ADDRESS+(EDX*4)
	
	cmpw	$EMU_SYS_CALL, %ax
	jnz	__normal_gp_exception_esi	/* no -> normal_gp_exception */

	/* yes, we have an int 80, prepare system call interface */
	movl	$-ENOSYS, PTREGS_ADDRESS+(EAX*4)
    	movl	%esi,PTREGS_ADDRESS+(ESI*4)

    	movl 	%edi,PTREGS_ADDRESS+(EDI*4)
	movl	%ebp,PTREGS_ADDRESS+(EBP*4)

	/* We don't save the exception number and error code because
	   it isn't needed to make a system call */
					
	movl	4(%esp),%eax			/* get eip */
	movl	8(%esp),%ecx			/* get cs */

	addl	$2, %eax			/* skip int 80 */
	movl	%ecx, PTREGS_ADDRESS+(CS*4)	/* save cs */

	movl	%eax, PTREGS_ADDRESS+(EIP*4)	/* save eip */
	movl	12(%esp), %ecx			/* get EFL */

	andl	$~CF_MASK, %ecx			/* clear carry */
    	
	leal	16(%esp), %esp			/* remove exception frame */
	movl 	%esp,PTREGS_ADDRESS+(UESP*4)	/* save esp */
	movl	%ecx,PTREGS_ADDRESS+(EFL*4)	/* save EFL */

        movl	$UEMULIB_STACK_INIT,%esp   

        pushl   %ebx
        call    filter_syscall
        popl    %ebx
        testl   %eax, %eax       /* if filter_syscall handled the syscall */
        jnz     __restore_regs   /*   skip calling linux */

#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low part of time stamp reg */
	movl	%eax, EMULIB_START_ADDRESS
#endif
	xorl	%eax, %eax

	xorl	%ecx, %ecx
	movl	$EMULIB_SYSCALL, %edx

	xorl	%ebp, %ebp
	movl	KERNEL_ID_ADDRESS, %esi

	movl	KERNEL_ID_ADDRESS+4, %edi

#ifdef DEBUG_IPC
	movl	KERNEL_ID_ADDRESS+8, %ebx
#endif
	ASM_ToLId
	int	$0x30
	ASM_FromLId
	
#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low part of time stamp reg */
	movl	%eax, EMULIB_STOP_ADDRESS
#endif
/* restore_regs function.
   restores content of registers from saved copy within
   exclusive page and uses a previously set up stack frame to return
*/
/*
 * write everything back from ptregs to registers
 * and simulate iret. Note that return value from syscall
 * is in ptregs.eax!
 * esp is set back to user esp (saved in ptregs)
 */

__restore_regs:	

 	movl	PTREGS_ADDRESS+(UESP*4), %esp
 	movl	PTREGS_ADDRESS+(EFL*4), %eax

    	movl	PTREGS_ADDRESS+(ECX*4),%ecx
	movl	PTREGS_ADDRESS+(EDX*4),%edx

    	movl	PTREGS_ADDRESS+(ESI*4),%esi
	movl 	PTREGS_ADDRESS+(UESP*4),%esp
	movl 	PTREGS_ADDRESS+(EDI*4),%edi

	pushl	%eax
 	movl	PTREGS_ADDRESS+(EIP*4), %eax

	pushl	%cs
      	movl	PTREGS_ADDRESS+(EBP*4),%ebp

	pushl	%eax
	movl 	PTREGS_ADDRESS+(EBX*4),%ebx
    
 	movl	PTREGS_ADDRESS+(EAX*4),%eax
	movl	$0,EMU_LOCAL_LOCK_ADDRESS

	iret

__normal_gp_exception_esi:	
#	ke	"general protection"
	movl	%ebx, PTREGS_ADDRESS+(EAX*4)
	pushl	$13
	jmp	__normal_exception_esi
		
		
/* divide error */
ENTRY(entry0)	
	pushl	$0		/* push missing error code */
	pushl	$0
	jmp	__handle_generalized_exception

/* debug exception */
ENTRY(entry1)
    	/* check for single step exception after a segmentation
	fault, adjust stack and jump back to entry19 */
	cmpl	$SYMBOL_NAME(entry19_fixup), (%esp) 
	jnz	__normal_trap
	addl	$12, %esp
	jmp	SYMBOL_NAME(entry19)
    
__normal_trap:	
    	pushl	$0		/* push missing error code */
	pushl	$1
	jmp	__handle_generalized_exception

/* int 2 nmi */
ENTRY(entry2)
	pushl	$0		/* push missing error code */
	pushl	$2
	jmp	__handle_generalized_exception

/* breakpoint */
ENTRY(entry3)
	pushl	$0		/* push missing error code */
	pushl	$3
	jmp	__handle_generalized_exception

/* overflow */
ENTRY(entry4)
	pushl	$0		/* push missing error code */
	pushl	$4
	jmp	__handle_generalized_exception

/* boundscheck */
ENTRY(entry5)
	pushl	$0		/* push missing error code */
	pushl	$5
	jmp	__handle_generalized_exception

/* invalid opcode */
ENTRY(entry6)
	pushl	$0		/* push missing error code */
	pushl	$6
	jmp	__handle_generalized_exception

/* int 7 */
ENTRY(entry7)
	pushl	$0		/* push missing error code */
	pushl	$7
	jmp	__handle_generalized_exception

/* double fault */
ENTRY(entry8)
	pushl	$8
	jmp	__handle_generalized_exception

/* coprocessor segment overrun */
ENTRY(entry9)
	pushl	$0		/* push missing error code */
	pushl	$9
	jmp	__handle_generalized_exception

/* invalid tss */
ENTRY(entry10)
	pushl	$10
	jmp	__handle_generalized_exception

/* segment not present */
ENTRY(entry11)
	pushl	$11
	jmp	__handle_generalized_exception

/* stack exception */
ENTRY(entry12)
	pushl	$12
	jmp	__handle_generalized_exception

/* general protection (exception 13) moved to end of list to remove jmp */
	
/* page fault */
ENTRY(entry14)
	pushl	$14
	jmp	__handle_generalized_exception

/* int 15 */
ENTRY(entry15)
	pushl	$15
	jmp	__handle_generalized_exception


/* coprocessor error */
ENTRY(entry16)
	pushl	$0		/* push missing error code */
	pushl	$16
	jmp	__handle_generalized_exception

ENTRY(entry17)
	pushl	$0		/* push missing error code */
	pushl	$17
	jmp	__handle_generalized_exception

ENTRY(entry18)
	pushl	$0		/* push missing error code */
	pushl	$18
	jmp	__handle_generalized_exception

/* used for fake_interrupt entry */
ENTRY(entry19)
	nop			/* if we are single stepping, we will
				   catch an exception at this point, 
				   therefore: Don't mess with
				   the stack until we are shure we don't 
				   do single stepping */
.globl SYMBOL_NAME(entry19_fixup)
SYMBOL_NAME_LABEL(entry19_fixup)
/*
 * Fill in required values to ptregs_struct
 *	some are already there
 */ 

	movl	%eax,PTREGS_ADDRESS+(ORIG_EAX*4)
	movl	%eax,PTREGS_ADDRESS+(EAX*4)
	movl 	%ebx,PTREGS_ADDRESS+(EBX*4)
	movl	%ecx,PTREGS_ADDRESS+(ECX*4)
	movl	%edx,PTREGS_ADDRESS+(EDX*4)

	movl	%esi,PTREGS_ADDRESS+(ESI*4)
	movl 	%edi,PTREGS_ADDRESS+(EDI*4)
	movl	%ebp,PTREGS_ADDRESS+(EBP*4)
	
	movl	$0, ERROR_CODE_ADDRESS 
    	movl	$19, EXCEPTION_NO_ADDRESS
	jmp	__switch_stack

	
	
__handle_generalized_exception:	

	/* first lock ex_page data */

	LOCK_EMU_LIB(__exception)
/*
 * Fill in required values to ptregs_struct
 *	some are already there
 */ 

	movl	%eax,PTREGS_ADDRESS+(ORIG_EAX*4)
	movl	%eax,PTREGS_ADDRESS+(EAX*4)
	movl 	%ebx,PTREGS_ADDRESS+(EBX*4)
	movl	%ecx,PTREGS_ADDRESS+(ECX*4)
	movl	%edx,PTREGS_ADDRESS+(EDX*4)
__normal_exception_esi:	
	movl	%esi,PTREGS_ADDRESS+(ESI*4)
	movl 	%edi,PTREGS_ADDRESS+(EDI*4)
	movl	%ebp,PTREGS_ADDRESS+(EBP*4)
	
	popl	%eax
	movl	%eax,EXCEPTION_NO_ADDRESS
	
/* skipped segment regs in LINUX_ON_L4! */		
	
/* errorcode, eip, cs and EFL are on the stack */
	movl	(%esp),%eax
	movl	4(%esp),%ebx
	movl	%eax,ERROR_CODE_ADDRESS
	movl	%ebx,PTREGS_ADDRESS+(EIP*4)
	movl	8(%esp),%eax
	movl	12(%esp),%ebx
	movl	%eax,PTREGS_ADDRESS+(CS*4)
	movl	%ebx,PTREGS_ADDRESS+(EFL*4)

/* save _user_ esp in ptregs ; set esp to emulib stack.*/

	leal	16(%esp), %esp
__switch_stack:	
	movl 	%esp,PTREGS_ADDRESS+(UESP*4)
#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low part of time stamp reg */
	movl	%eax, EMULIB_START_ADDRESS
#endif
	xorl	%eax, %eax
	xorl	%ecx, %ecx
	movl	$EMULIB_EXCEPTION, %edx
	movl	$EMULIB_EXCEPTION, %ebx
	xorl	%ebp, %ebp
	movl	KERNEL_ID_ADDRESS, %esi
	movl	KERNEL_ID_ADDRESS+4, %edi

#ifdef DEBUG_IPC
	movl	KERNEL_ID_ADDRESS+8, %ebx
#endif
	ASM_ToLId
    	int	$0x30
	ASM_FromLId
	
#ifdef	MEASURE_SYSCALL_PATH      
	ASM_RDTSC /* edx scratched, eax contains low paort of time stamp reg */
	movl	%eax, EMULIB_STOP_ADDRESS
#endif
/*
 * write everything back from ptregs to registers
 * and simulate iret. Note that return value from syscall
 * is in ptregs.eax!
 * esp is set back to user esp (saved in ptregs)
 */
	jmp	__restore_regs


ENTRY(user_level_pager)
    movl    $(UPAGER_STACK_INIT), %esp
#if 0
    int	$3
    jmp	1f
    .ascii	"pager started"
#endif    
1:
wait_loop:      
    movl    $-1, %eax	    # no send message
receive_loop:	    
    xorl    %ecx, %ecx	    # timeout never
    movl    $1, %ebp	    # receive short messages only, open wait
    int	    $0x30	    # invoke ipc (open wait)
			    # check for local message
    ASM_FromLId
    movl    %esi, %ecx
    xorl    USER_ID_ADDRESS, %ecx
    andl    $EMU_TASK_MASK, %ecx
    jnz	    wait_loop	    # message from another task, ignore

#if 0    
    int	$3
    jmp	1f
    .ascii	"pf received"
#endif    
1:
    
    LOCK_EMU_LIB(__page_fault)
    movl    $3, EMU_LOCAL_LOCK_ADDRESS	# emulib locked + pager active
    # forward the pagefault message to L4Linux
    movl    %esi, FAULTING_THREAD
    movl    %edi, FAULTING_THREAD+4
        
	xorl	%eax, %eax  # short send message
	xorl	%ecx, %ecx  # timeout never
	movl	$(32*4 + 2), %ebp
	movl	KERNEL_ID_ADDRESS, %esi
	movl	KERNEL_ID_ADDRESS+4, %edi
	
	ASM_ToLId
	int	$0x30
	ASM_FromLId

    # release lock
    movl	$0,EMU_LOCAL_LOCK_ADDRESS
#if 0
    int	$3
    jmp	1f
    .ascii	"reply received"
#endif    
1:
        
    # send reply to faulting thread, the pagefault should be resolved
    xorl    %eax, %eax	    # short send message
    movl    FAULTING_THREAD, %esi
    movl    FAULTING_THREAD+4, %edi
    
    jmp	receive_loop
    
ENTRY(user_task_init)
/* load idt */
    leal    emulib_idt_descr, %eax
    lidt    (%eax)
#    ke	"idt loaded"

/* create signal thread */
    movl    $1,   %eax				#create thread number one
    movl    $SYMBOL_NAME(handle_signals), %edx	#eip = handle_signals
    movl    $(USIGNAL_STACK_INIT), %ecx		#esp = end of signal stack

    movl    KERNEL_ID_ADDRESS, %esi		#load pager id, 
						# touch exclusive page
    movl    KERNEL_ID_ADDRESS+4, %edi		#load pager id

    movl    $-1,    %ebx			#preempter=nil id    
    movl    %ebx,   %ebp			#preempter=nil id
	
    ASM_ToLId
    int	    $0x35
    ASM_FromLId

    /* and now activate our new process :) */    
    
/* activate_process function.
   restores content of registers from prepared copy within
   exclusive page to start the process after fork.
   Special function because we can't touch the stack while process creation
*/

ENTRY(activate_process)

	movl 	PTREGS_ADDRESS+(EBX*4),%ebx
	movl	PTREGS_ADDRESS+(ECX*4),%ecx
	movl	PTREGS_ADDRESS+(EDX*4),%edx
	movl	PTREGS_ADDRESS+(ESI*4),%esi
	movl 	PTREGS_ADDRESS+(EDI*4),%edi
	movl	PTREGS_ADDRESS+(EBP*4),%ebp
	movl	PTREGS_ADDRESS+(EAX*4),%eax
	leal	PTREGS_ADDRESS+(EFL*4), %esp
	popfl
	movl	PTREGS_ADDRESS+(UESP*4), %esp

	movl	$0,EMU_LOCAL_LOCK_ADDRESS

/* XXX argh... how can I jmp to the user without touching ptregs after
   releasing the lock and without touching the user stack before??? */
		
	jmp	*(PTREGS_ADDRESS+(EIP*4))


EMULIB_LOCKED(__real_sys_call)
EMULIB_LOCKED(__sys_call)
EMULIB_LOCKED(__exception)
EMULIB_LOCKED(__page_fault)	

ENTRY(do_nothing_loop)
again:	jmp again

#define D_SEG_PRESENT	0x8000 /*(0x01 << 15)*/
#define D_USER		0x6000 /*(0x03 << 13)*/
#define D_TRAPGATE      0x0f00 /*(0x0f <<  7)*/
     
.MACRO	IDT_ENTRY entry
.AIF	"\entry" EQ ""    
    .long   0
.AELSE
    .long   SYMBOL_NAME(\entry)
.AENDI        
    .long   D_SEG_PRESENT + D_USER + D_TRAPGATE 
.ENDM

#ifdef CONFIG_L4_USER_ENTER_KDEBUG
# define BREAK_POINT_KERNEL_EVENT
#endif
	
/* #define	SINGLE_STEP_KERNEL_EVENT    */
    .align  4
    .globl  emulib_idt_descr
emulib_idt_descr:
    .word   20 * 8 -1
    .long   idt_table	

    .align  4
    .globl  idt_table
idt_table:  
    IDT_ENTRY	entry0
#ifdef	SINGLE_STEP_KERNEL_EVENT
    IDT_ENTRY
#else
    IDT_ENTRY	entry1
#endif            
    IDT_ENTRY
#ifdef	BREAK_POINT_KERNEL_EVENT
    IDT_ENTRY
#else
    IDT_ENTRY	entry1
#endif            
    IDT_ENTRY	entry4
    IDT_ENTRY	entry5
    IDT_ENTRY	entry6
    IDT_ENTRY	entry7
    IDT_ENTRY	entry8
    IDT_ENTRY	entry9
    IDT_ENTRY	entry10
    IDT_ENTRY	entry11
    IDT_ENTRY	entry12
    IDT_ENTRY	entry13
    IDT_ENTRY	entry14
    IDT_ENTRY	entry15
    IDT_ENTRY	entry16
    IDT_ENTRY	entry17
    IDT_ENTRY	entry18
    IDT_ENTRY	entry19

    .align  4
    .globl  emulib_idt_descr
emulib_debug_idt_descr:
    .word   20 * 8 -1
    .long   debug_idt_table	

    .align  4
    .globl  debug_idt_table
debug_idt_table:  
    IDT_ENTRY	entry0
    IDT_ENTRY	/* entry1 */
    IDT_ENTRY	/* entry2 */
    IDT_ENTRY	/* entry3 */
    IDT_ENTRY	entry4
    IDT_ENTRY	entry5
    IDT_ENTRY	entry6
    IDT_ENTRY	entry7
    IDT_ENTRY	entry8
    IDT_ENTRY	entry9
    IDT_ENTRY	entry10
    IDT_ENTRY	entry11
    IDT_ENTRY	entry12
    IDT_ENTRY	entry13
    IDT_ENTRY	entry14
    IDT_ENTRY	entry15
    IDT_ENTRY	entry16
    IDT_ENTRY	entry17
    IDT_ENTRY	entry18
    IDT_ENTRY	entry19
    
.END 













