/* $Id: user.c,v 1.1.1.1 1999/04/06 19:36:10 yoonho Exp $
   Signal handling code.
*/

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>
#include <l4/kdebug.h>

#include "../include/task.h" 
#include "../include/user.h"
#include "../include/shared_data.h"

#include <asm/bitops.h>

/* #define DEBUG */

/* see fake_interrupts.c  */
void 
handle_signals(void)
{
  l4_threadid_t user_id,sender_thread_id, preempter_id, linux_pager_id;
  dword_t P1,P2,old_eflags, old_eip, *old_esp;
  l4_msgdope_t result;
  dword_t cs;

  user_id=l4_myself();
  user_id.id.lthread = LTHREAD_NO_USER_THREAD;
  asm("movl $0, %%eax\n\t"
      "movw %%cs, %%ax\n\t"
      : "=a" (cs)
      );

  /* thread designated to handle fake_ints */
  for(;;)
    {
      if(l4_i386_ipc_wait(&sender_thread_id,0,&P1,&P2, 
			  L4_IPC_NEVER, &result))
	{
	  /* tell("DispatchMessage: IPC-wait error\n"); */
	  continue;
	}

      /* try local lock (Bit EMULIB_LOCK_BIT of emu_local_lock).  If
	 set, user thread is already within the kernel or the user
	 level pager has forwarded a page fault to the Linux server.
	 If the pager isn't active there is no need to do a zero
	 syscall.

	 Otherwise, get the lock (if the pager hasn't already locked
	 the emulation library), save registers to ptregs, force the
	 user thread into a zero syscall.  Other places we deal with
	 the lock is in the emulation code in int_entry.S.

	 XXX: There is still a bug in there. If we have multiple user
	 threads and use a pager to serialize system calls and page
	 faults we have to decide, to which thread the signal should
	 be send. And we have to ex_regs the pager out of its receive
	 operation, since he won't get an answer after a segmentation
	 fault.  
      */

      /* if ( (emulib locked) && (pager not active) )
       *    continue;
       */
      if (test_and_set_bit(EMULIB_LOCK_BIT, &(shared_data_ptr->emu_local_lock))
	  && !test_bit(EMULIB_PAGER_BIT, &(shared_data_ptr->emu_local_lock)))
	continue;

      /* reset pager bit, if there is another signal before this one
         is finished we simply ignore it */
       clear_bit(EMULIB_PAGER_BIT, &(shared_data_ptr->emu_local_lock));

#ifdef DEBUG
      enter_kdebug("propagate signal: ex_regs");
#endif
      /* set user thread looping forever */
      l4_thread_ex_regs(user_id, 
			(dword_t) do_nothing_loop, 
			/* XXX esp not required ? */
			(dword_t) shared_data_ptr->uemulib_stack+
			STACK_SIZE_UEMULIB, 
			&preempter_id, &linux_pager_id, &old_eflags, &old_eip, 
			(dword_t*) &old_esp);
 
#ifdef DEBUG
      kd_display("to: ");
      outhex32(old_eip);
#endif
      /* We try to avoid touching the user stack since we can't be
         sure that we don't raise a page fault. Instead we simply put
         the values into pt_regs and use a special exception handler
         for our faked exception, which knows about the special
         location of esp, eip and eflags */
      shared_data_ptr->regs.eflags=old_eflags;
      shared_data_ptr->regs.eip = old_eip;
    
      /* take user thread out of loop, generate 'faked' exception 19 */
      l4_thread_ex_regs(user_id, 
			(dword_t) entry19, 
			(dword_t)old_esp, 
			&preempter_id, &linux_pager_id, &old_eflags, &old_eip, 
			(dword_t*)&old_esp);
#ifdef DEBUG
      kd_display("finished\n\r");
#endif
      /* signal thread continues here, user thread does an exception
	 19 and goes back immediately afterwards to user code.  */

      /* we don't try to aquire the lock while working on exception
         19, therefore we don't release it */
      /* clear_bit(1, &(exclusive_page_ptr->emu_local_lock)); */
    }
}

int
filter_syscall(unsigned syscallnum)
{
  int handled = 0;
  l4_msgdope_t msgdope;
  unsigned dw1, dw2, dw3;
  int firsttime = 1, firstprint = 1;
  volatile int vi;

#if 0
  switch (shared_data_ptr->regs[EBX]) {
    case __NR_read:
    case __NR_write:
  }
#endif
  if (shared_data_ptr->regs.eip == 0x805c1a0) {
    kd_display("805c1a0\n");
    enter_kdebug("soon to die");
  }
  while (7847228) {
    char ch;
    /* wait for return from syscall or copy_(to|from)_user */
    asm volatile (
      "pushl %%ebp\n\t"
      "xorl  %%ebp,%%ebp\n\t"
      ToLId
      "int   $0x30\n\t"             /* l4 ipc call */
      "popl  %%ebp"
      : "=a"(msgdope),
        "=d"(dw1),
        "=b"(dw2),
        "=D"(dw3)
      : "c"(0),
        "S"(shared_data_ptr->kernel_id.lh.low),
        "D"(shared_data_ptr->kernel_id.lh.high),
        "d"(EMULIB_SYSCALL),
        "b"(syscallnum),
        "0"(0)
      : "eax","ebx","ecx","edx","esi","edi","cc"
    );
    if (msgdope.msgdope != 0) {
      outhex32(msgdope.msgdope);
      enter_kdebug ("ipc call error");
    }
    ch = '\0';
    switch (dw3) {
      case 1: /* copy_from_user    */
        if (ch == '\0') ch = 'f';
      case 2: /* copy_to_user      */
        if (ch == '\0') ch = 't';
      case 3: /* clear_user        */
        if (ch == '\0') ch = 'c';
      case 4: /* strncpy_from_user */
        if (ch == '\0') ch = 'n';
      case 5: /* strlen_from_user  */
        if (ch == '\0') ch = 'l';
        for (vi = 0; vi < 200000; vi++);
        outchar(ch);
        outchar(',');
        outchar(((syscallnum / 100) % 10) + '0');
        outchar(((syscallnum / 10)  % 10) + '0');
        outchar(((syscallnum / 1)   % 10) + '0');
        outchar(',');
        outhex32(dw1);
        outchar(',');
        outhex32(dw2);
        if (firstprint) {
          outchar('#');
          firstprint = 0;
        }
        outchar('\r');
        outchar('\n');
        continue;
      default:
        outchar('d');
        outhex32(dw3);
        outchar('\r');
        outchar('\n');
        enter_kdebug("uh oh");
      case 0:
        return 1; /* syscall returned */
    }
  }
}
   
