/* $Id: config.h,v 1.3 1999/05/19 20:39:20 volkmar Exp $ */

#ifndef __L4_I386_CONFIG_H
#define __L4_I386_CONFIG_H

#include <linux/config.h>       /* our new fancy config-stuff */
#include <asm/processor.h>	/* for TASK_SIZE */

#ifndef CONFIG_L4
#error L4-arch not configured - please run make menuconfig/xconfig
#endif

#ifdef CONFIG_L4_USE_PRIOS
# define USE_PRIOS		/* L4 priorities for Linux server
				   kernel threads */
#endif

#ifdef CONFIG_L4_SMALL_SPACES
# define USE_SMALL_SPACES CONFIG_L4_SMALL_SPACE_SIZE	
                                /* do we use small address spaces, and
				   their size in MB */
#endif

#ifdef CONFIG_L4_USE_SUPER_CLAN
# define USE_SUPER_CLAN	        /* use supervisor (rmgr) for all task
				   creations, yielding "flat" clan */
#endif


#ifdef CONFIG_L4_TAME_SERVER
#define TAME_SERVER 	        /* only use machine-cli for PIC
				   programming, and use irq-lock;
				   implied by __SMP__ */
#endif


#ifdef CONFIG_L4_BROKEN_L4_SCHEDULE
# define BROKEN_L4_SCHEDULE 	/* l4_thread_schedule (and prios)
				   don't work -- use on old versions of L4 */
#endif



#define PRIO_IRQ(x) (CONFIG_L4_PRIO_IRQ - (x))	/* x = 15..0  -> prio 129..144 */
#define PRIO_BOTTOM_HALF (CONFIG_L4_PRIO_BOTTOM_HALF)
#define PRIO_KERNEL (CONFIG_L4_PRIO_KERNEL)
#define PRIO_ROOT (CONFIG_L4_PRIO_ROOT)
#define PRIO_USER_PROCESS (CONFIG_L4_PRIO_USER_PROCESS)

#define MCP_SUPER   (CONFIG_L4_MCP_SUPER)
#define MCP_KERNEL  (CONFIG_L4_MCP_KERNEL)
#define MCP_USER    (CONFIG_L4_MCP_USER)

/* L4 thread numbers for Linux server kernel threads */

#ifdef CONFIG_L4_TID /* did we config it via the config-tool ??? */

#define LTHREAD_NO_LINUX_CHIEF	(0)   /* this is fixed of L4 */
#define LTHREAD_NO_LINUX_SERVER	(CONFIG_L4_TID_LINUX_SERVER)
#define LTHREAD_NO_PROC_UNSELECT (CONFIG_L4_TID_PROC_UNSELECT)
#define LTHREAD_NO_IRQ(x) 	(CONFIG_L4_TID_IRQ + (x)) /* x = 0..15  -> threadno 16..31*/
#define LTHREAD_NO_BOTTOM_HALF 	(CONFIG_L4_TID_BOTTOM_HALF)
#define LTHREAD_NO_ROOT_EXEC 	(CONFIG_L4_TID_ROOT_EXEC)
#define LTHREAD_NO_ROOT_PAGER	(CONFIG_L4_TID_ROOT_PAGER)
#define LTHREAD_NO_SIG_SEGV	(CONFIG_L4_TID_SIG_SEGV)


#define LTHREAD_NO_USER_THREAD	(0) /* fixed */
#define LTHREAD_NO_SIGNAL_THREAD (CONFIG_L4_TID_SIGNAL_THREAD)

#else /* CONFIG_L4_TID */

/* default assignements of Linux-thread numbers */

#define LTHREAD_NO_LINUX_CHIEF	(0)   /* this is fixed of L4 */
#define LTHREAD_NO_LINUX_SERVER	(3)
#define LTHREAD_NO_PROC_UNSELECT (2)
#define LTHREAD_NO_IRQ(x) 	(16 + (x)) /* x = 0..15  -> threadno 16..31*/
#define LTHREAD_NO_BOTTOM_HALF 	(32)
#define LTHREAD_NO_ROOT_EXEC 	(33)
#define LTHREAD_NO_ROOT_PAGER	(34)
#define LTHREAD_NO_SIG_SEGV	(35)


#define LTHREAD_NO_USER_THREAD	(0)
#define LTHREAD_NO_SIGNAL_THREAD	(1)

#endif /* CONFIG_L4_TID */

#define NO_IRQS 16		/* number of machine interrupts */

/* stack sizes */
#define INIT_USER_STACK_START 1021
#define STACK_SIZE_CHIEF 512
#define STACK_SIZE_PROC_UNSELECT 512
#define STACK_SIZE_IRQ (1024)
#define STACK_SIZE_BOTTOM_HALF (1024)
#define STACK_SIZE_ROOT_EXEC (1024)
#define STACK_SIZE_SIG_SEGV (512)
#define STACK_SIZE_USIGNAL (512)
#define STACK_SIZE_UEMULIB (512)
#define STACK_SIZE_UPAGER (64)

/* L4 task numbers */
#define TASK_NO_MIN (CONFIG_L4_TASK_NO_MIN)
#define TASK_NO_MAX (CONFIG_L4_TASK_NO_MAX)

/* basis address for shared data */
#define SHARED_DATA_ADDRESS (TASK_SIZE)
#define EMULIB_CODE_ADDRESS (TASK_SIZE + 0x8000)


/* address of kernel info page */
#define KERNEL_INFO_PAGE_ADDRESS (0x1000)

/* end of user-configurable section */



/* some invariants follow */
#ifdef __SMP__
# define TAME_SERVER
#endif

#ifdef BROKEN_L4_SCHEDULE
# undef USE_PRIOS
# undef USE_SMALL_SPACES
# ifndef TAME_SERVER
#  define TAME_SERVER
# endif
#endif

#endif /* ! __L4_I386_CONFIG_H */
