#ifndef __L4_I386_IDS_H
#define __L4_I386_IDS_H

#include <l4/syscalls.h>
#include <asm/page.h>

/* #define DEBUG_GET_ID */
extern inline l4_threadid_t
get_l4_id_from_stack(void)
{
  unsigned esp;
  asm("movl	%%esp, %0\n\t" : "=r" (esp) : /* No input */);
#ifdef DEBUG_GET_ID
  if (!thread_equal(l4_myself(),
		    *(l4_threadid_t *)((esp & PAGE_MASK) 
				       + PAGE_SIZE - sizeof(l4_threadid_t))))
    {
      enter_kdebug("id_mismatch");
      id = l4_myself();
    }
#endif
  return  *(l4_threadid_t *)((esp & PAGE_MASK) 
			     + PAGE_SIZE - sizeof(l4_threadid_t)); 
}
/* #define DEBUG_PUT_ID */
extern inline void
put_l4_id_to_stack(unsigned esp, l4_threadid_t id)
{
  *(l4_threadid_t *)
    ((esp & PAGE_MASK) + PAGE_SIZE - sizeof(l4_threadid_t)) = id; 
#ifdef DEBUG_PUT_ID
  outhex32(esp);
  enter_kdebug("put_l4_id");
#endif
}
#endif
