/* $Id: shared_data.h,v 1.1.1.1 1999/04/06 19:36:11 yoonho Exp $ */

/* Structure definition for data shared between the linux server and
 * each incarnation of linux process. Holds pt_regs structure, and
 * information neccessary for ipc. */

#ifndef __L4_I386_SHARED_DATA_H 
#define __L4_I386_SHARED_DATA_H

#include "config.h"

#ifndef __ASSEMBLY__
#include <l4/types.h>
#include <asm/ptrace.h> /* struct ptregs */
#endif

#include "task.h" /* idt types */

#define EMULIB_IPC 		(-4)  /* special value,
					 denoting msg from emulib */
#define EMULIB_SYSCALL		(-3)  /* special value denoting system call */
#define EMULIB_EXCEPTION	(-4)  /* special value denoting exception */
#define EMULIB_MSG_MASK		(0xfffffffc)
#define IS_EMULIB_MSG(msg_w0)	((msg_w0 & EMULIB_MSG_MASK) == EMULIB_IPC)
#define EMULIB_LOCK_BIT		0
#define EMULIB_PAGER_BIT	1

#ifndef __ASSEMBLY__
struct measure {
  unsigned long syscall_start, syscall_stop;
  unsigned long emulib_start, emulib_stop;
  unsigned long linux_server_start, linux_server_stop;
  unsigned long dispatch_start, dispatch_stop;
};

struct shared_data {
  struct measure m;
  char dummy[1024];
  l4_threadid_t kernel_id;
  l4_threadid_t user_id;	/* used by signal thread */
  l4_threadid_t pagefault_id;
  struct pt_regs regs;
  int exception_number;
  unsigned int error_code;
  /* local lock which prevents the signal 
     thread to generate a 0-syscall 
     when syscall is already in progress */
  atomic_t emu_local_lock;
  char usignal_stack[STACK_SIZE_USIGNAL];
  char uemulib_stack[STACK_SIZE_UEMULIB];
  char upager_stack[STACK_SIZE_UPAGER];
};

#if 0				/* can we get rid of this? */
#define M_VALUES_INIT {0, 0, 0, 0, 0, 0, 0, 0}
#define SHARED_DATA_INITIALIZER { M_VALUES_INIT, {0, }, \
			      L4_NIL_ID, L4_NIL_ID, L4_NIL_ID,\
			      PTREGS_INITIALIZER, 0, 0, 0,\
			      {"SIGNALSTACK"}, {"EMUSTACK" }, {"PAGERSTACK" }};
#endif

#define shared_data_ptr ((struct shared_data *) SHARED_DATA_ADDRESS)

#endif /* __ASSEMBLY__ */

#define ZERO_SYSCALL_NUMBER 0xef

/* offsets for exclusive page members */
#define EMULIB_START_ADDRESS (SHARED_DATA_ADDRESS + 2*4)
#define EMULIB_STOP_ADDRESS (SHARED_DATA_ADDRESS + 3*4)

#define KERNEL_ID_ADDRESS  (SHARED_DATA_ADDRESS + 8*4 + 1024)
#define USER_ID_ADDRESS    (KERNEL_ID_ADDRESS+8)
#define FAULTING_THREAD     (USER_ID_ADDRESS+8)
#define PTREGS_ADDRESS     (FAULTING_THREAD+8)
#define EXCEPTION_NO_ADDRESS (PTREGS_ADDRESS+PTREGS_SIZE)
#define ERROR_CODE_ADDRESS (EXCEPTION_NO_ADDRESS+4)
#define EMU_LOCAL_LOCK_ADDRESS (ERROR_CODE_ADDRESS+4)
#define USIGNAL_STACK_INIT (EMU_LOCAL_LOCK_ADDRESS + 4 \
			    +STACK_SIZE_USIGNAL)
#define UEMULIB_STACK_INIT (USIGNAL_STACK_INIT+STACK_SIZE_UEMULIB)
#define UPAGER_STACK_INIT (UEMULIB_STACK_INIT+STACK_SIZE_UPAGER)

#define OFFS_PTREGS (PTREGS_ADDRESS - SHARED_DATA_ADDRESS)
#endif /* __L4_I386_SHARED_DATA_H */

