/* $Id: task.h,v 1.1.1.1 1999/04/06 19:36:11 yoonho Exp $ */

#ifndef __L4_I386_TASK_H
#define __L4_I386_TASK_H

#ifndef __ASSEMBLY__
#include <linux/sched.h>
#include <l4/types.h>
#include "ids.h"

int root_task_execute(int (*subroutine)(int arg), int arg);
void start_root_task_execute_thread(void);
void start_special_init_task(dword_t eip, dword_t esp);
pid_t create_special_user_task(int (*fn)(void *), void * arg, 
			       unsigned long flags);
void 
start_linux_server_thread(dword_t eip, dword_t esp);
void
sig_kill_received(void);

extern l4_threadid_t template_id;
extern l4_sched_param_t template_schedparam;
extern l4_threadid_t kernel_thread_id;
extern unsigned long kernel_taskno;

void task_no_init(void);
int task_no_alloc(void);
int task_no_free(int n);

/* task_to_proc manipulations */
#define L4_IDLE_STACK_USAGE (sizeof(l4_threadid_t) + sizeof(unsigned long))
void set_task_to_proc_entry(int task_no, struct task_struct *p);
void clear_task_to_proc_entry(int task_no);
struct task_struct *get_task_struct(int task_no);

/*
 * Exception handling
 */

#define TRAPGATE        0x70
#define USERLEVEL       0x03
#define SEGPRESENT      0x01
#endif /* ifndef ASSEMBLY */

#define NUM_DEFAULT_INT_HANDLER (0x14)

#ifndef __ASSEMBLY__

typedef struct { 
   unsigned int_handler_low:  16; 
   unsigned selector:       16; 
   unsigned reserved:        5; 
   unsigned trapgate:        8; 
   unsigned privilege:       2; 
   unsigned present:         1; 
   unsigned int_handler_high: 16;
} idt_entry_t;

typedef idt_entry_t l4_idt_t[NUM_DEFAULT_INT_HANDLER];
typedef void (*int_handler_t)(void);

typedef struct 
{
    unsigned short int size __attribute__((packed));
    unsigned long address __attribute__((packed));
} idt_descr_t;

typedef struct 
{
  int edi, esi;
  int ebp;
  int dummy_esp;                 /* thrown away in popa */
  int ebx, edx, ecx, eax;
  int number;
  int error, eip, cs, eflags;
  int stack_top;
} exception_frame_t;



extern int_handler_t default_int_handler_array[NUM_DEFAULT_INT_HANDLER];

void set_default_idt(void);
void set_idt(idt_entry_t *idt, int_handler_t *int_handler, int num);

asmlinkage void def_int_handler(exception_frame_t frame);
asmlinkage void def_int_entry0(void);
asmlinkage void def_int_entry1(void);
asmlinkage void def_int_entry2(void);
asmlinkage void def_int_entry3(void);
asmlinkage void def_int_entry4(void);
asmlinkage void def_int_entry5(void);
asmlinkage void def_int_entry6(void);
asmlinkage void def_int_entry7(void);
asmlinkage void def_int_entry8(void);
asmlinkage void def_int_entry9(void);
asmlinkage void def_int_entry10(void);
asmlinkage void def_int_entry11(void);
asmlinkage void def_int_entry12(void);
asmlinkage void def_int_entry13(void);
asmlinkage void def_int_entry14(void);
asmlinkage void def_int_entry15(void);
asmlinkage void def_int_entry16(void);
asmlinkage void def_int_entry17(void);
asmlinkage void def_int_entry18(void);
asmlinkage void def_int_entry19(void);

#endif /* ifndef assembly */

/* for offset calculations in excl-page */

#define IDT_SIZE (8*NUM_DEFAULT_INT_HANDLER)
#define IDT_DESCR_SIZE 8

#ifndef __X_ADAPTION__
# define TASKNO_MASK	0x0ffe0000
# define TASKNO_SHIFT   17
#else
# define TASKNO_MASK    0x0ffe0000
# define TASKNO_SHIFT   17
#endif

#endif /* ! __L4_I386_TASK_H */
