/*
 *  linux/arch/l4-i386/head.S -- the 32-bit startup code.
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  adapted for l4/linux   
 */

.text
#include <linux/tasks.h>
#include <linux/linkage.h>
#include "../include/mb_info.h"
/*
 * References to members of the boot_cpu_data structure.
 */

#define CPU_PARAMS	SYMBOL_NAME(boot_cpu_data)
#define X86		CPU_PARAMS+0
#define X86_VENDOR	CPU_PARAMS+1
#define X86_MODEL	CPU_PARAMS+2
#define X86_MASK	CPU_PARAMS+3
#define X86_HARD_MATH	CPU_PARAMS+6
#define X86_CPUID	CPU_PARAMS+8
#define X86_CAPABILITY	CPU_PARAMS+12
#define X86_VENDOR_ID	CPU_PARAMS+16

#define STACK_SIZE_CHIEF (512 - 4)
/*
 * swapper_pg_dir is the main page directory, address 0x00101000
 */
ENTRY(stext)
ENTRY(_stext)
startup_32:
	leal	SYMBOL_NAME(chief_stack), %esp

/* check for a multiboot-compliant boot */
	cmpl	$MULTIBOOT_VALID, %eax
	jnz	1f
	movl	%ebx, SYMBOL_NAME(multiboot_info)
1:	
	    
        
/* some basic cpu type checking */
	movl $4,X86		# at least 486
	movl %ecx,%eax
	xorl $0x200000,%eax	# check ID flag
	pushl %eax
	popfl			# if we are on a straight 486DX, SX, or
	pushfl			# 487SX we can't change it
	popl %eax
	xorl %ecx,%eax
	pushl %ecx		# restore original EFLAGS
	popfl
	andl $0x200000,%eax
	je is486

	/* get vendor info */
	xorl %eax,%eax			# call CPUID with 0 -> return vendor ID
	cpuid
	movl %eax,X86_CPUID		# save CPUID level
	movl %ebx,X86_VENDOR_ID		# lo 4 chars
	movl %edx,X86_VENDOR_ID+4	# next 4 chars
	movl %ecx,X86_VENDOR_ID+8	# last 4 chars

	orl %eax,%eax			# do we have processor info as well?
	je is486

	movl $1,%eax		# Use the CPUID instruction to get CPU type
	cpuid
	movb %al,%cl		# save reg for future use
	andb $0x0f,%ah		# mask processor family
	movb %ah,X86
	andb $0xf0,%al		# mask model
	shrb $4,%al
	movb %al,X86_MODEL
	andb $0x0f,%cl		# mask mask revision
	movb %cl,X86_MASK
	movl %edx,X86_CAPABILITY

is486:
    
    	
        jmp	SYMBOL_NAME(__linux_startup)


    
    
/* Some data structures needed to boot linux and to set some basic
   things like paging up */

ENTRY(multiboot_info)		.long	 0    

/*
 * multiboot header
 */	
 	/* MultiBoot header - see multiboot.h.  */
#ifdef __ELF__
 	.align	4
#else /* ! __ELF__, that mean a.out assembler */
	.align	2
#endif

boot_hdr:
 	.long	0x1BADB002		/* magic */
 	.long	0x00010000		/* flags: AOUT_KLUDGE */
	.long   - 0x00010000 - 0x1BADB002
 	.long	boot_hdr		/* header_addr */
 	.long	SYMBOL_NAME(startup_32)	/* load_addr */
 	.long	SYMBOL_NAME(__bss_start)/* load_end_addr */
 	.long	SYMBOL_NAME(_end)	/* bss_end_addr */
 	.long	SYMBOL_NAME(startup_32)	/* entry */

ENTRY(null_pointer_check)
	.long	0
ENTRY(syscall_count)
	.long	0
ENTRY(kernel_idt)
        .rept 0x20
                .long 0
        .endr

.org 0x1000
ENTRY(swapper_pg_dir)

.org 0x2000
ENTRY(pg0)

.org 0x3000
ENTRY(empty_bad_page)

.org 0x4000
ENTRY(empty_bad_page_table)

.org 0x5000
ENTRY(empty_zero_page)

.org 0x6000
ENTRY(emu_lib_text)

.org 0x7000
ENTRY(task_to_proc)		/* needs 2048 x 4 bytes */
    
.org 0x9000
        
.data
	.long 0xdeadbeef
	.fill STACK_SIZE_CHIEF
ENTRY(chief_stack)    