/* $Id: l4_idle.S,v 1.2 1999/08/11 15:21:40 luked Exp $ */

#include <asm/ptrace.h> /* ptregs , offsets */
#include <asm/processor.h> 
#include "../include/task.h"
#include "../include/shared_data.h"
#include "../include/gasp.h"	
#include <linux/sys.h>
#include <linux/linkage.h>
#include <services/sys/genericdm.h>
#include <services/sys/rmm.h>

#ifdef __X_ADAPTION__
# include <l4/xadaption.h>
#else
# define ASM_FromLId
# define ASM_ToLId
#endif
    
/* send mantisse = 0, send exp <> 0 => send timeout 0  */
#define PF_EUSER (4)
#define PF_EWRITE (2)
#define PF_EREAD (0)
#define PF_EPROTECTION (1)
#define PF_ENOTPRESENT (0)

#define PAGE_SIZE 0x1000
#define L4_IDLE_STACK_USAGE 12    

#define DEBUG_WATCH_SP         
/*          
#define DEBUG_WATCH_SP         
#define DEBUG_PRINT_SWITCH
#define	COUNT_EVENTS    
#define COUNT_SYSTEM_CALLS
*/
    
            
/* #define	MEASURE_SYSCALL_PATH */  
#ifdef	MEASURE_SYSCALL_PATH
#define OFFS_SERVER_START 16
#define OFFS_SERVER_STOP 20    
#include "../include/perform.h"
#endif
 
.MACRO ko text
/* #define DEBUG_IDLE_KO*/
#ifdef DEBUG_IDLE_KO    
        int $3
	cmpb	$\text, %al
#endif    
.ENDM

.MACRO real_ko text
        int $3
	cmpb	$\text, %al
.ENDM

.file	"l4_idle.S"
last_pf:    .long 0

#ifdef SCHEDULE_AFTER_BH
bh_count:    .long 5    
#endif
    
#include "syscall.S"
#include "pagefault.S"
    	
    
    
    
        /*
Note:		
	Every process has a special frame on top of its own
	stack. It looks like follows:

				idle process	    normal process

    	kernel_stack + 0xffc    myself.high		myself.high
	kernel_stack + 0xff8    myself.low		myself.low

	l4_idle is basically some code that waits for a message
	handles it and send a reply. If we receive a message we have
	to switch to the appropriate context to handle it. For a
	wakeup message the appropriate context is the idle process
	which will call schedule after beeing activated. For a message
	from the user the appropriate context is the associated
	'kernel process'. Since we can be in either the idle context
	or in a normal process context while waiting for a message, we
	have three different cases while switching:

	    idle->user:	 after receiving a system call
    	    user->user:	 after receiving a system call
	    user->idle:	 after receiving a wakeup message

	If we switch to a user we expect the users stackpointer to
	point to a fixed offset within its stack, since there is
	nothing on the stack if the user part is running. The stack
	contains valid information only when the user activity is
	executing kernel code. So we don't care about the current
	kernel state of the process we are switching to and simply
	reinitialize its stack frame using a known value before
	starting to handle the received message.

	If we switch away from a user we also don't care about its
	current state. The user part is running so there is nothing we
	have to keep track of within the kernel. There is only one
	situation when the user part is running and we need a valid
	kernel stack and that is the handling of SIGKILL. If we have
	to send a SIGKILL to a process we set it running and rely an
	schedule()/switch_to() to activate this process. And
	switch_to() relies on a valid stack frame. We deal with this
	situation while sending SIGKILL (we basically create a valid
	stack frame before calling schedule()).

	The difficult part is switching to the idle process and
	switching away from it. Since idle() ist activated by
	schedule()/switch_to() if no other process is running we have
	to have a valid stack frame for idle() at all times. So we
	have to save and restore the state of idle() using the same
	scheme used by switch_to();

    sys_idle implements the following algorithm:

    REPEAT
	IF reschedule needed
	    schedule
	    CONT
	ELSE
	    wait for a message
	    IF	ipc ok
		IF  wakeup message (msg from thread within kernel task)
		    send reply
		    schedule
		    CONT
		ELSE
		    lookup process
		    IF	process expects system call
			switch to process (never returns)
		    ELSE
			ke  "unexpected system call"
			CONT
		    ENDIF
		ENDIF
	    ELSE
		ke  "wait error"
	    ENDIF
    	ENDIF
    ENDR

    dispatch message implements the following algorithm:

    REPEAT
	REPEAT
	    save client id
	    IF	message from emulation library
		IF system call
		    set tss.under_kernel_control
		    dispatch system call
		    IF process not under kernel control anymore
			EXIT (no reply necessary, reschedule)
		    ENDIF
		    reset tss.under_kernel_control		    
		ELSE (exception)
		    set tss.under_kernel_control
		    handle exception
    		    reset tss.under_kernel_control    
		ENDIF
	    ELSE (page fault)
		set tss.under_kernel_control
		handle page fault
    		reset tss.under_kernel_control
	    ENDIF

    	    restore client id
	    IF error while message dispatch
		EXIT (no reply, reschedule)
	    ENDIF
	    begin atomar
	    IF	reschedule not needed
		mark idle sleeping
		send reply and wait for next order
		mark idle activ
		end atomar
		IF ipc ok
		    IF not wakeup message
			lookup process
			IF message for me
			    CONT (dispatch message)
			ELSE
			    IF process expects system call
				switch to process
				CONT (dispatch message)
			    ELSE
				ke  "process doesn't expect system call"
				EXIT (reschedule)
			    ENDIF
			ENDIF
		    ELSE
			send reply
			EXIT (reschedule)
		    ENDIF			
		ELSE
		    ke "error in reply and wait"
		    EXIT (reschedule)
		ENDIF
	    ELSE
		end atomar
		send reply
		IF ipc ok
		    EXIT    (reschedule)
		ENDIF
		ke  "send error"
		EXIT	(reschedule)
	    ENDIF
	ENDR
	schedule
	ke  "sig_kill received?"
	handle sig_kill
    ENDR
*/

.MACRO SWITCH_IDLE_TO_USER 
/*	
    Precond:
	ebp:	new process struct task_struct
    	esp & 0xfff = PAGE_SIZE - L4_IDLE_STACK_USAGE + sizeof(idle return address)

    Postcond:
	*tss.kernel_sp:  valid return address
	esp:	kernel stack of process we switched to
	eip:	dispatch_msg	
    
    Scratched:	
	nothing
    
*/
#ifdef DEBUG_WATCH_STACK
	pushl	%ebp
	/* remember pushed ebp and not yet pushed return address*/
	movl	%esp, %ebp
	andl	$0xfff, %ebp
	cmpl	$(PAGE_SIZE-L4_IDLE_STACK_USAGE), %ebp
	jz  1f
	ke 'i2u: wrong value for old stack'
    1:
	popl	%ebp
#endif
	pushl	$1f
	movl	%esp, (-2*PAGE_SIZE + OFFS_KERNEL_ESP + L4_IDLE_STACK_USAGE)(%esp)
	leal	(2*PAGE_SIZE-L4_IDLE_STACK_USAGE)(%ebp), %esp
	jmp	dispatch_msg
    1:  
.ENDM    

.MACRO SWITCH_USER_TO_USER 
/*	
    Precond:
	ebp:	new process struct task_struct
    	esp & 0xfff = PAGE_SIZE - L4_IDLE_STACK_USAGE

    Postcond:
	esp:	kernel stack of process we switched to
    
    Scratched:	
	nothing
    
*/
#ifdef DEBUG_WATCH_STACK
	pushl	%ebp
	/* remember pushed ebp */
	movl	%esp, %ebp
	andl	$0xfff, %ebp
	cmpl	$(PAGE_SIZE-L4_IDLE_STACK_USAGE-4), %ebp
	jz  1f
	ke 'u2u: wrong value for old stack'
    1:
	popl	%ebp
#endif
	leal	(2*PAGE_SIZE-L4_IDLE_STACK_USAGE)(%ebp), %esp
.ENDM    

.MACRO SWITCH_USER_TO_IDLE 
/*	
    Precond:
	ebp:	new process struct task_struct
    	esp & 0xfff = PAGE_SIZE - L4_IDLE_STACK_USAGE

    Postcond:
	esp:	kernel stack of idle process
	eip:	address we switched away from	
    
    Scratched:	
	nothing
    
*/
#ifdef DEBUG_WATCH_STACK
	pushl	%ebp
	/* remember pushed ebp */
	movl	%esp, %ebp
	andl	$0xfff, %ebp
	cmpl	$(PAGE_SIZE-L4_IDLE_STACK_USAGE-4), %ebp
	jz  1f
	ke 'u2i: wrong value for old stack'
    1:
	popl	%ebp
#endif
	movl	OFFS_KERNEL_ESP(%ebp), %esp
	ret
.ENDM

/* The Linux idle process.  It is invoked at boot time from sys_idle(). */

	
ENTRY(l4_idle)
    /* adjust stack, return address still missing */
    andl	$0xfffff000, %esp 
    addl	$(PAGE_SIZE-L4_IDLE_STACK_USAGE+4), %esp

    /* XXX at some point we handled bottom halfs within the idle
       context, I don't know why, so please check this again */
    REPEAT
        cli
        IFNZ	SYMBOL_NAME(global_need_resched), $0
	    /* reschedule needed, enable interrupts and call schedule */
	    sti
    	    call    SYMBOL_NAME(schedule)
	    CONT
	ELSE
	    /* nothing to do, wait for order or wakeup */
	    movl    $1, SYMBOL_NAME(idle_sleeping)
	    xorl    %ecx, %ecx		
	    leal    -1(%ecx), %eax
    	    leal    1(%ecx), %ebp
	    ASM_ToLId
4:
	    int	    $0x30
            cmpl    $req_genericdm_dm_map_page,%edi
            jne     1f
                xorl    %edx,%edx
                xchg    %edx,%ebx
                jmp     3f
1:
            cmpl    $req_genericdm_dm_close,%edi
            je      2f
            cmpl    $req_rmm_pgr_stop_paging_rm,%edi
            jne     3f
2:
                movl    $1,  %ebp
                movl    $-1, %eax
                xorl    %ecx,%ecx
                jmp     4b
3:
	    ASM_FromLId

	    orl	    %eax, %eax
	    movl    %esi, %ecx

	    movl    $0, SYMBOL_NAME(idle_sleeping)
	    IFZ

		shrl	$(TASKNO_SHIFT-2), %ecx
    	        andl    $(TASKNO_MASK >> (TASKNO_SHIFT-2)), %ecx

	        sti
    
	        IFNZ	%ecx, SYMBOL_NAME(kernel_taskno)
		    movl    SYMBOL_NAME(task_to_proc)(%ecx), %ebp

    		    IFZ	    OFFS_UNDER_KERNEL_CONTROL(%ebp), $0
    			/* switch to associated thread */
    			SWITCH_IDLE_TO_USER 
			/* we return here, if someone switches back. */
			CONT
		    ELSE
			ke "l4_idle: under control"
			CONT
		    ENDIF
		ELSE
		    /* hmm, it was a wakeup, call send reply and reschedule */
		    xorl    %eax,%eax
		    leal    -1(%eax),	%ebp
		    ASM_ToLId
		    int	    $0x30
		    ASM_FromLId
		    CONT
		ENDIF
	    ELSE
		/* hmm, something went wrong, for some reason our ipc failed */
		ke "l4_idle: ipc failed"
		CONT
	    ENDIF
	ENDIF
    ENDR
    ke "l4_idle: never reached"

	
/* ------------------------------------------------------------------
     
    dispatch message dispatches an incoming message to its respective
    kernel coroutine. Then the result is send to the process.
    If there is no other activity going on in the kernel, the
    dispatch_msg waits for a new order. Otherwise it calls schedule to
    switch to another activ kernel coroutine.
    
    dispatch_msg is activated by SWITCH_IDLE_TO_USER when l4_idle() 
    receives a message from a user task wishing to enter the kernel.

    PRECONDITION:	edx,ebx:    message
    			esi,edi:    source id
			current, current_tss and current_pdir point
			to context of current process  
   ------------------------------------------------------------------ */

ALIGN

dispatch_msg:	
REPEAT
    REPEAT
	/* dispatch message */
	pushl	%esi
	pushl	%edi	/* save client id */
	decl	SYMBOL_NAME(nr_running_user) /* user entered kernel */
	movl	$1, OFFS_UNDER_KERNEL_CONTROL(%ebp)
    
	IFZ	%edx, $EMULIB_SYSCALL

		DISPATCH_SYSCALL

    		/* if we aren't under kernel control anymore (i. e. after 
		   execve), we have to call schedule to activate another 
		   process or idle */
    		IFZ	OFFS_UNDER_KERNEL_CONTROL(%ebp), $1
		    xorl	%ecx, %ecx
		    jmp		__end_dispatch
		ELSE
		    call    SYMBOL_NAME(start_thread_really)
		    addl    $8, %esp
		    EXIT
		ENDIF

	ELSE
/*	    IFNZ	%edx, $EMULIB_EXCEPTION*/
	    cmpl    $EMULIB_EXCEPTION, %edx
	    jz	    __exception
    
/*	    page fault */
	    HANDLE_PAGE_FAULT
#ifdef CHECK_ASM_LOOKUP
	    pusha
	    pushl   %ebx
	    pushl   %edx
	    call SYMBOL_NAME(check_lookup)
	    popl    %edx
	    popl    %ebx
	    popa
#endif    
	    orl	    %eax, %eax
    	    jns	    __end_dispatch
    
	    /* segmentation fault, no reply */
    	    movl	$0, OFFS_UNDER_KERNEL_CONTROL(%ebp)
	    popl	%edi
	    popl	%esi
	    EXIT		/* reschedule */
	    
/*	    ELSE*/
__exception:	
		/* ke	"exception" */
		call	SYMBOL_NAME(deliver_signal)
		xorl	%ecx, %ecx
		jmp		__end_dispatch
/*	    ENDIF*/
	ENDIF

	/* deliver result if necessary */
__end_dispatch
	    cli
	    movl SYMBOL_NAME(bh_mask),%eax
	    andl SYMBOL_NAME(bh_active),%eax
	    jne handle_bottom_half
    
__cont_ret_from_syscall:    
    	    IFNZ    SYMBOL_NAME(global_need_resched), $0
	    /* save reply parameters (eax, ecx, edx) */
		sti
       		pushl	%eax
		pushl	%ecx
		pushl	%edx
		ko	0x73
		call	SYMBOL_NAME(schedule)
		cli
		popl	%edx
    		popl	%ecx
    		popl	%eax
    	    ENDIF
	    movl	$0, OFFS_UNDER_KERNEL_CONTROL(%ebp)
	    incl	SYMBOL_NAME(nr_running_user)
	    popl	%edi
	    popl	%esi

	    /* send reply and wait for a new order */
    	    movl    $1, 	SYMBOL_NAME(idle_sleeping)

	    movl    $1,		%ebp 	/* open wait */
	    movl    %ecx,	%eax
	    movl    $SYSCALL_TIMEOUT,   %ecx
	    /* ke  "send reply" */
	    ASM_ToLId
4:
            xor     %edi,%edi
	    int	    $0x30
            cmpl    $req_genericdm_dm_map_page,%edi
            jne     1f
                xorl    %edx,%edx
                xchg    %edx,%ebx
                jmp     3f
1:
            cmpl    $req_genericdm_dm_close,%edi
            je      2f
            cmpl    $req_rmm_pgr_stop_paging_rm,%edi
            jne     3f
2:
                movl    $1,  %ebp
                movl    $-1, %eax
                xorl    %ecx,%ecx
                jmp     4b
3:
            ASM_FromLId
	    orl	    %eax, %eax
	    movl    %esi, %ecx

	    movl    $0, SYMBOL_NAME(idle_sleeping)
	    IFZ

		shrl	$(17-2), %ecx
    	        andl    $(TASKNO_MASK >> (17-2)), %ecx
	        sti
    
	        movl    SYMBOL_NAME(task_to_proc)(%ecx), %ebp

	        CONTZ	%ebp, %eax /* msg for me, dispatch it */
    
	        IFNZ	%ecx, SYMBOL_NAME(kernel_taskno)
    		    IFNZ	OFFS_UNDER_KERNEL_CONTROL(%ebp), $0    
			/* process doesnt expects sys call, reschedule */
			ke	    "unexpected system call"
			EXIT
		    ENDIF
		    SWITCH_USER_TO_USER
		    CONT /* dispatch message */
		ELSE
    		    /*  hmm, it was a wakeup, send reply, switch to
			idle and don't return */
		    xorl    %eax,%eax
		    leal    -1(%eax),	%ebp
	            ASM_ToLId
		    int	    $0x30
		    ASM_FromLId
		    movl    $SYMBOL_NAME(init_task_union), %ebp
    		    SWITCH_USER_TO_IDLE
		    ke "dispatch_msg:	 Ooops, returned"
		    EXIT
    		ENDIF
	    ELSE
		ke	"reply_and_wait error"
		EXIT
	    ENDIF
    ENDR

1:      
    movl    $SYMBOL_NAME(init_task_union), %ebp
    movl    $1, SYMBOL_NAME(global_need_resched)
    SWITCH_USER_TO_IDLE
    /* should never return */
    ke "dispatch_msg:	 Ooops, returned"
    jmp	1b
ENDR

/* handle_bottom_half is a sub-routine for dispatch_msg().  As it is
   called from only one place, we don't need to use call/ret but can
   use jmps instead. */

ALIGN

handle_bottom_half:
    pushl	%eax
    pushl	%ecx
    pushl	%edx
    call	SYMBOL_NAME(do_bottom_half)
    popl	%edx
    popl	%ecx
    popl	%eax
    jmp __cont_ret_from_syscall



END
