#define SYSCALL_TIMEOUT 0x10
#define CF_MASK		0x00000001	 
#define ENOSYS		38  
#define flags		4    
    
/*
    Precond:	
		ebx:	system call number
		ebp:	tss of current task
    
    Postcond:	
		eax:	return value of dispatched function
		ecx:	value to be used as msg dope for reply
		edx:	dw0 to be used for reply    	
    		ebx:	dw1 to be used for reply
    Scratched:	
		edi, esi

    dispatch syscall implements the following algorithm:

    get	address of ptregs
    result := -ENOSYS (no such system call)
    IF	system call number is valid
	get address of system call
	IF address of system call is valid
	    clear carry flag in ptregs
	    IF	not system call trace activ
		reserve space on stack for ptregs structure
		transfer first 5 dwords from ptregs structure 
		    to stack (system call parameters)
		invoke system call
		remove parameters from stack (simply adjust stack pointer)
		result:= eax
	    ELSE
		trace system call
		reserve space on stack for ptregs structure
		transfer first 5 dwords from ptregs structure 
		    to stack (system call parameters)
		invoke system call
		remove parameters from stack (simply adjust stack pointer)
		result:= eax
		trace system call
	    ENDIF
	ENDIF
    ENDIF				 
    IF signal pending
	do_signal
    ENDIF
    
*/               
.MACRO DISPATCH_SYSCALL
#define sigpending 8
sys_call .REG	(%ebx)

ptregs	.REG	(%edi)
current	.REG	(%ebp)
tmp1	.REG	(%ecx)
tmp2	.REG	(%edx)

/* #define COUNT_SYSTEM_CALLS     */
    /* get ptregs */
#ifdef COUNT_SYSTEM_CALLS    
    incl    SYMBOL_NAME(syscall_count)
#endif    
    movl    OFFS_EXCLUSIV_PAGE(current), ptregs
    /* check whether sys call is valid */
    IFL	    %ebx, $(NR_syscalls)
	    movl	OFFS_PTREGS(ptregs), tmp1
	    testb   $0x20, flags(current)      # PF_TRACESYS
	    IFZ
		/* push parameters */
		leal	-PTREGS_SIZE(%esp), %esp
    		movl	(OFFS_PTREGS+4)(ptregs), tmp2
		movl	tmp1, (%esp)
    		movl	tmp2, 4(%esp)
		movl	(OFFS_PTREGS+8)(ptregs), tmp1
    		movl	(OFFS_PTREGS+12)(ptregs), tmp2
		movl	tmp1, 8(%esp)
		movl	(OFFS_PTREGS+16)(ptregs), tmp1
    		movl	tmp2, 12(%esp)
		movl	tmp1, 16(%esp)
		
		call SYMBOL_NAME(sys_call_table)(,%ebx,4)

    		leal	PTREGS_SIZE(%esp), %esp

		movl	%eax,	(OFFS_PTREGS+(EAX*4))(ptregs)
	    ELSE
		call SYMBOL_NAME(syscall_trace)

		/* push parameters */
		leal	-PTREGS_SIZE(%esp), %esp
		movl	OFFS_PTREGS(ptregs), tmp1
    		movl	(OFFS_PTREGS+4)(ptregs), tmp2
		movl	tmp1, (%esp)
    		movl	tmp2, 4(%esp)
		movl	(OFFS_PTREGS+8)(ptregs), tmp1
    		movl	(OFFS_PTREGS+12)(ptregs), tmp2
		movl	tmp1, 8(%esp)
		movl	(OFFS_PTREGS+16)(ptregs), tmp1
    		movl	tmp2, 12(%esp)
		movl	tmp1, 16(%esp)
		
		call SYMBOL_NAME(sys_call_table)(,%ebx,4)

    		leal	PTREGS_SIZE(%esp), %esp
		movl	%eax,	(OFFS_PTREGS+(EAX*4))(ptregs)

    		call SYMBOL_NAME(syscall_trace)
	    ENDIF
    ENDIF
    /* we never handle system calls within the context of idle and we
	have to use fast calling conventions for do_signals */
    IFNZ	sigpending(current), $0
	addl    $OFFS_PTREGS, ptregs
	xorl    %edx, %edx
    	movl	ptregs, %eax
	call SYMBOL_NAME(do_signal)
    ENDIF
    xorl    %eax, %eax

sys_call .REG	(%xxx1)

ptregs	.REG	(%xxx2)
current	.REG	(%xxx3)
tmp1	.REG	(%xxx4)
tmp2	.REG	(%xxx5)


    
.ENDM    

