/*
$Id: fake_interrupt.c,v 1.2 1999/05/13 15:43:29 yoonho Exp $
*/

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/kdebug.h>
#include <l4/syscalls.h>

#include <linux/sched.h>

#include <asm/atomic.h>

#include "../include/task.h"
#include "../include/sched.h"
#include "../include/fake_interrupt.h"

#define FAKE_INT_FIRST_COOKIE 0x28041970
#define FAKE_INT_SECOND_COOKIE 0x23081971
/* #define DEBUG */

void
generate_fake_interrupt(struct task_struct *p)
{
  int error;
  l4_timeout_t timeout = L4_IPC_TIMEOUT(0,1,0,0,0,0); /* snd timeout = 0 */
  l4_msgdope_t result;
  l4_threadid_t signal_thread_id = p->tss.user_thread_id;
  /* send special message to user task, thread LTHREAD_NO_SIGNAL_THREAD */
  signal_thread_id.id.lthread = LTHREAD_NO_SIGNAL_THREAD;

#ifdef DEBUG
  herc_printf("generating fake interrupt for %x.%x)\n", 
	      signal_thread_id.id.task, signal_thread_id.id.lthread); 
#endif

  /* we send fake irq messages with timeout 0; a timeout is non-fatal
     as that means the signal thread is already busy telling the user to
     enter the kernel. */

  error = l4_i386_ipc_send(signal_thread_id, L4_IPC_SHORT_MSG,
			   FAKE_INT_FIRST_COOKIE,
			   FAKE_INT_SECOND_COOKIE, timeout, &result);
#ifdef DEBUG
  if (error == L4_IPC_ENOT_EXISTENT) {
    herc_printf("gfi: destination %x.%x not existing )\n",
		signal_thread_id.lh.high, signal_thread_id.lh.low);
    enter_kdebug("GFI: ENOT_EXISTENT");
  }
#endif

  /* XXX: Due to some timing problems it can happen, that the signal
     thread isn't ready for signal handling. Therefore we kick it and
     try it again. Maybe we can use a really small timeout to kick the
     signal thread during ipc ? */

  if (error == L4_IPC_SETIMEOUT)
    {
      l4_thread_switch(signal_thread_id);
      error = l4_i386_ipc_send(signal_thread_id, L4_IPC_SHORT_MSG,
			       FAKE_INT_FIRST_COOKIE,
			       FAKE_INT_SECOND_COOKIE, timeout, &result);
      if (error == L4_IPC_SETIMEOUT)
	{
#if 0
	  enter_kdebug("gfi: timeout after retry");
#endif /* 0 */
	}
    }

  if (error && (error != L4_IPC_SETIMEOUT))
    {
      printk("generate_fake_interrupt: IPC-send error (%x) "
	     "while sending to %x(%s)\n from %s, sigs %lx\n", 
	     error, signal_thread_id.lh.low, p->comm, current->comm, 
	     p->signal.sig[0]);
#if 0 
      enter_kdebug("generate_fake_interrupt");
#endif
    }
}

void l4_post_signal(struct task_struct *t, int sig)
{
  if (! atomic_read(&t->tss.under_kernel_control) 
      && signal_pending(t))
    {
      if (sig == SIGKILL)
	{
	  /* Special magic: Make it possible to kill a
	     non-cooperating task.

	     We accomplish this by creating a special context on the
	     offending thread's kernel stack and then switching over
	     to it. */

	  /* Calculate kernel stack pointer.  This method is
             equivalent to the one used in process.c:thread_create(). */
	  unsigned long *sp 
	    = (unsigned long *) ((unsigned long)t + 
				 sizeof(union task_union) 
				 - L4_IDLE_STACK_USAGE);
  
	  *(--sp) = 0;		/* fake return address for emulated func call*/
	  *(--sp) = (unsigned long) sig_kill_received;

	  t->tss.kernel_sp = (unsigned long) sp;

	  /* OK, now wait for the scheduler to select the
	     vicious process. >:-) */
	  atomic_set(&t->tss.under_kernel_control, 1);
	  nr_running_user--;

	  current->need_resched = 1;
	}
      else
	generate_fake_interrupt(t);
    }
}
