#include <linux/kernel.h>
#include <asm/atomic.h>
#include <asm/bitops.h>

#include "../include/debug.h"

#include <l4/kdebug.h>

#define LOCK_BIT 0
atomic_t herc_lock = ATOMIC_INIT(0);

static char herc_buf[2048];
asmlinkage int herc_printf(const char *fmt, ...)
{
  va_list args;
  int i;
  char *p, *buf_end;

  if (!test_and_set_bit(LOCK_BIT,&herc_lock))
    {
      va_start(args, fmt);
      i = vsprintf(herc_buf, fmt, args); /* hopefully i < sizeof(herc_buf)-4 */
      
      if (!(i < sizeof(herc_buf)))
	enter_kdebug("herc_printf buffer overflow");
      
      buf_end = herc_buf + i;
      va_end(args);
      for (p = herc_buf; p < buf_end; p++) {
	if (*p == '\n')
	  {
	    outchar('\r');
	    outchar('\n');
	  }
	else
	  outchar(*p);
      }
      clear_bit(LOCK_BIT, &herc_lock);
      return i;
    }
  else
    {
      kd_display("herc_print locked\\r\\n");
      return 0;
    }
}
