#include <l4/syscalls.h>
#include <l4/ipc.h>
#include <l4/kdebug.h>

l4_threadid_t 
create_thread (int thread_no, void (*function)(void), void *stack)
{
  l4_threadid_t preempter, pager;
  dword_t dummy;

  /* get thread parameters */
  l4_threadid_t ret = l4_myself();

  preempter = L4_INVALID_ID;
  pager = L4_INVALID_ID;

  l4_thread_ex_regs(ret, 
		    (dword_t) -1, (dword_t) -1,
		    &preempter,
		    &pager,
		    &dummy,
		    &dummy,
		    &dummy);

  /* save thread id */
  ret.id.lthread = thread_no;

  /* create thread */
  l4_thread_ex_regs(ret,
		    (dword_t) function, /* eip */
		    (dword_t) stack, /* esp */
		    &preempter, /* preempter */
		    &pager,	/* pager */
		    &dummy,	/* old_flags */
		    &dummy,	/* old_eip */
		    &dummy);	/* old_esp */
  return ret;
}

void l4_sleep(int ms)
{
  int error,to_e,to_m;
  dword_t dummy;
  l4_msgdope_t result;
  l4_timeout_t to;

  if (ms != -1)
    {
      /* calculate timeout */
      micros2l4to(ms * 1000,&to_e,&to_m);
      to = L4_IPC_TIMEOUT(0,0,to_m,to_e,0,0);
    }
  else
    to = L4_IPC_NEVER;
  
  error = l4_i386_ipc_receive(L4_NIL_ID,L4_IPC_SHORT_MSG,
                              &dummy,&dummy,to,&result);
 
  if (error != L4_IPC_RETIMEOUT)
    {
      outstring("(l4_sleep): IPC error\n\r");
    }
}


unsigned long flz(unsigned long word);

__inline__ unsigned long flz(unsigned long word)
{
  __asm__("bsrl %1,%0"
	  :"=r" (word)
	  :"r" (~word));
  return word;
}

int micros2l4to(int mus, int *to_e, int *to_m)
{
  if (mus <= 0)
    {
      *to_e = 1;
      *to_m = 0;
    }
  else
    {
      *to_e = 14 - (flz(~(mus / 256))) / 2;
      *to_m = mus / (1UL << (2 * (15 - *to_e)));
      
      if ((*to_e < 0) || (*to_e > 15) || (*to_m < 0) || (*to_m > 255))
        {
	  outstring("micros2l4to: mus = ");
	  outdec(mus);
	  outstring(", to_e = ");
	  outdec(*to_e);
	  outstring(", to_m = ");
	  outdec(*to_m);
	  outstring("\n\r");
	  enter_kdebug("micros2l4to");

	  return -1;
        }
    }
  return 0;
}
