#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>
#include <l4/kdebug.h>

#include <asm/sync.h>

#include <linux/kernel.h>  /* printk(...) */
#include <asm/system.h>    /* cli/sti */

#define LOCK_IPC_MAGIC_1 0xc01ad05e
#define LOCK_IPC_MAGIC_2 0x26091975


void 
init_queue(sync_queue_t* queue)
{
    if (!thread_equal(queue->id, L4_INVALID_ID)) return;

    queue->p_next = queue->p_prev = queue;
    queue->id = L4_NIL_ID;
}

void
get_lock(sync_queue_t* queue) 
{
    struct sync_queue_t this;
    l4_threadid_t waker, me;
    l4_msgdope_t result;
    dword_t dummy[2];

    // this is necessary for the great great linux design...
    init_queue(queue);

    me = l4_myself();
    
    __cli();

    if (thread_equal(queue->id, L4_NIL_ID)) {
	queue->id = me;
	//__sti();
	return;
    }
    //printk("thread %x in wait_queue\n", queue->id.lh.low);
    this.id = me;
    
    this.p_next = queue;
    queue->p_prev->p_next = &this;
    this.p_prev = queue->p_prev;
    queue->p_prev = &this;

    waker = queue->id;

    if (l4_i386_ipc_receive(waker, L4_IPC_SHORT_MSG,
			    &dummy[0], &dummy[1],
			    L4_IPC_NEVER, &result))
	enter_kdebug("get_lock: receive error");
    
    if (!(dummy[0] == LOCK_IPC_MAGIC_1 && dummy[1] == LOCK_IPC_MAGIC_2)) 
	enter_kdebug("get_lock: unlock-ipc is fucked up!");

    // int's are still disabled

    // unqueue myself
    queue->id = this.id;
    queue->p_next = this.p_next;
    this.p_next->p_prev = queue;
    __sti();
}

void
get_lock_irq(sync_queue_t* queue) 
{
    struct sync_queue_t this;
    l4_threadid_t waker, me;
    l4_msgdope_t result;
    dword_t dummy[2];

    // this is necessary for the great great linux design...
    init_queue(queue);

    me = l4_myself();
    
    __cli();

    if (thread_equal(queue->id, L4_NIL_ID)) {
	queue->id = me;
	__sti();
	return;
    }
    //printk("thread %x in wait_queue\n", queue->id.lh.low);
    this.id = me;
    
    this.p_next = queue;
    queue->p_prev->p_next = &this;
    this.p_prev = queue->p_prev;
    queue->p_prev = &this;

    waker = queue->id;

    if (l4_i386_ipc_receive(waker, L4_IPC_SHORT_MSG,
			    &dummy[0], &dummy[1],
			    L4_IPC_NEVER, &result))
	enter_kdebug("get_lock: receive error");
    
    if (!(dummy[0] == LOCK_IPC_MAGIC_1 && dummy[1] == LOCK_IPC_MAGIC_2)) 
	enter_kdebug("get_lock: unlock-ipc is fucked up!");

    // int's are still disabled

    // unqueue myself
    queue->id = this.id;
    queue->p_next = this.p_next;
    this.p_next->p_prev = queue;
}
       
void 
free_lock(sync_queue_t *queue)
{
    l4_msgdope_t result;
    if (queue->p_next == queue) {
	queue->id = L4_NIL_ID;
	return;
    }

    if (l4_i386_ipc_send(queue->p_next->id, L4_IPC_SHORT_MSG,
			 LOCK_IPC_MAGIC_1, LOCK_IPC_MAGIC_2,
			 L4_IPC_NEVER, &result))
    {
	printk("free_lock: could not wake up %x (err: %x) (%x->%x)\n", 
	       queue->p_next->id.lh.low, result.msgdope, queue, queue->p_next);
	enter_kdebug("wakeup");
    }
}

int try_lock(sync_queue_t *queue)
{
    init_queue(queue);

    __cli();
    if (thread_equal(L4_NIL_ID, queue->id)) {
	get_lock(queue);
	return 1;
    }
    return 0;
}


