/* $id: task.c,v 1.25 1996/07/02 18:28:26 hohmuth exp $ */

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>

#include <linux/sched.h>

#include <asm/bitops.h>

#include "../include/config.h"
#include "../include/l4_memory.h"
#include "../include/shared_data.h"
#include "../include/rmgr.h"
#include "../include/debug.h"
#include "../include/assert.h"

/* we implement this interface: */
#include "../include/task.h"

#ifdef USE_SUPER_CLAN
# define l4_task_new rmgr_task_new
#endif

void task_no_init(void);

int l4_task_version = 0;

#ifdef IDLE_THREAD
#define IDLE_STACK_SIZE 50
static int idle_stack[IDLE_STACK_SIZE];
#endif

void
idle_loop(void)
{
  int count = 0;
  while(1) {
    count &= 3;
    *((char *)0xb0f9e) = "|/-\\"[count++];
  }
}

l4_threadid_t kernel_thread_id;
unsigned long kernel_taskno;
unsigned long nr_running_user;
/* task number management */
#define BITVEC_SIZE (TASK_NO_MAX - TASK_NO_MIN + 1)
#define VEC_SIZE    (BITVEC_SIZE / sizeof(unsigned) + 1)

static unsigned task_used[VEC_SIZE] 
  = {0, };

int task_no_alloc(void) 
{
  int n = find_first_zero_bit(task_used, BITVEC_SIZE);

  if (n > BITVEC_SIZE)
    return -1;

  set_bit(n, task_used);
  if (++l4_task_version > 127)
    l4_task_version = 0;

  return TASK_NO_MIN + n;
}

int task_no_free(int n)
{
  n -= TASK_NO_MIN;
  if (n < 0 || n >= BITVEC_SIZE)
    return -1;

  if (! test_and_clear_bit(n, task_used))
    return -1;

  return 0;
}

void task_no_init(void)
{
  int err;
  unsigned i;

  if (! have_rmgr)		/* do we have a supervisor? */
    return;

  for (i = TASK_NO_MIN; i <= TASK_NO_MAX; i++)
    {
      err = rmgr_get_task(i);

      if (err != 0)
	set_bit(i  - TASK_NO_MIN, task_used); /* can't alloc this task nno */
    }
}

/* task_to_proc manipulations */
extern struct task_struct* task_to_proc[TASK_NO_MAX+1];
void 
set_task_to_proc_entry(int task_no, struct task_struct *p)
{
  ASSERT(task_no <= TASK_NO_MAX);
  task_to_proc[task_no] = p;
}
void 
clear_task_to_proc_entry(int task_no)
{
  ASSERT(task_no <= TASK_NO_MAX);
  task_to_proc[task_no] = 0;
}
struct task_struct *
get_task_struct(int task_no)
{
  ASSERT(task_no <= TASK_NO_MAX);
  return task_to_proc[task_no];
}



int_handler_t default_int_handler_array[NUM_DEFAULT_INT_HANDLER] =
{
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
};

void 
set_idt(idt_entry_t *idt, int_handler_t *int_handler, int num)
{
  int i;

  /* XXX Do we need a seperate idt_descr for each idt ? */
  idt_descr_t idt_descr = {num * 8 - 1, (unsigned long)idt};
  idt_entry_t dummy = { 0, 0, 0, TRAPGATE, USERLEVEL, SEGPRESENT, 0 }; 

  for (i=0; i<num; i++)
    {
      dummy.int_handler_low  =  (long)int_handler[i];
      dummy.int_handler_high = ((long)int_handler[i]) >> 16;
      idt[i] = dummy;
    }
  asm("lidt	(%%eax)\n\t" : : "a" (&idt_descr)); 
}

static idt_entry_t default_idt[NUM_DEFAULT_INT_HANDLER];
void set_default_idt(void)
{

  printk("set_default_idt disabled\n");
/*   static idt_entry_t default_idt[NUM_DEFAULT_INT_HANDLER]; */
/*   set_idt(default_idt, default_int_handler_array,  */
/* 	  NUM_DEFAULT_INT_HANDLER);    */
}

void default_int_handler_func(exception_frame_t frame)
{
  panic("exception %x triggered at eip: %x with error %x\n"
	"eax: %x, ebx: %x, ecx: %x, edx: %x\n"
	"esi: %x, edi: %x, ebp: %x, esp: %x\n",
	frame.number, frame.eip, frame.error, 
	frame.eax, frame.ebx, frame.ecx, frame.edx, 
	frame.esi, frame.edi, frame.ebp, (unsigned int)&frame.stack_top);
}
