#include <l4/kdebug.h>
#include <asm/uaccess.h>
#include "../include/l4_memory.h"

int __get_user_byte(unsigned char *val,   const void *address)
{
#if 0
  unsigned long page, offset;
  page = parse_ptabs_read((unsigned long)address, &offset);
  if (page != -EFAULT) {
    *val = *(char *)(page + offset);
    return 0;
  }
  else {
    enter_kdebug("int __get_user_byte returns efault");
    return -EFAULT;
  }
#else
  copy_from_user (val, address, sizeof(*val));
#endif
}

int __get_user_short(unsigned short *val, const void *address)
{
#if 0
  unsigned long page, offset;
  if (((unsigned long)address & ~PAGE_MASK) != ~PAGE_MASK) {
    page = parse_ptabs_read((unsigned long)address, &offset);
    if (page != -EFAULT) {
      *val = *(unsigned short *)(page + offset);
      return 0;
    }
    else {
      enter_kdebug("int __get_user_short returns efault");
      return -EFAULT;
    }
  }
  else {
    unsigned char low, high;
    if ((__get_user_byte(&low, address) != -EFAULT) && 
	(__get_user_byte(&high, address+1) != -EFAULT)) {
      *val = (unsigned short)low + ((unsigned short)high << 8);
      return 0;
    }
    else {
      enter_kdebug("int __get_user_short returns efault");
      return -EFAULT;
    }
  }
#else
  copy_from_user (val, address, sizeof(*val));
#endif
}

int __get_user_long(unsigned long *val,   const void *address)
{
#if 0
  unsigned long page, offset;
  if (((unsigned long)address & ~PAGE_MASK) <= (PAGE_SIZE - sizeof(*val))) {
    page = parse_ptabs_read((unsigned long)address, &offset);
    if (page != -EFAULT) {
      *val = *(unsigned long *)(page + offset);
      return 0;
    }
    else {
      enter_kdebug("int __get_user_short returns efault");
      return -EFAULT;
    }
  }
  else {
    switch ((unsigned long)address &3) 
      {
      case 1:
      case 3:
	{
	  unsigned char first, third;
	  unsigned short second;
	  if ((__get_user_byte(&first, address) != -EFAULT)&& 
	      (__get_user_short(&second, address+1) != -EFAULT) &&
	      (__get_user_byte(&third, address + 3) != -EFAULT))
	    {
	      *val = first + 
		((unsigned long)second << 8) +
		((unsigned long)third << 24);
	      return 0;
	    }
	case 2:
	  {
	    unsigned short first, second;
	    if ((__get_user_short(&first, address) != -EFAULT)&& 
		(__get_user_short(&second, address+2) != -EFAULT))
	      {
		*val = first + ((unsigned long)second << 16);
		return 0;
	      }
	  }
	}
      }
    enter_kdebug("int __get_user_long returns efault");
    return -EFAULT;
  }
#else
  copy_from_user (val, address, sizeof(*val));
#endif
}

int __put_user_byte(unsigned char val,   const void *address)
{
#if 0
  unsigned long page, offset;
  page = parse_ptabs_write((unsigned long)address, &offset);
  if (page != -EFAULT) {
    *(char *)(page + offset) = val;
    return 0;
  }
  else {
    enter_kdebug("int __put_user_byte returns efault");
    return -EFAULT;
  }
#else
  copy_to_user (address, &val, sizeof(val));
#endif
}

int __put_user_short(unsigned short val, const void *address)
{
#if 0
  unsigned long page, offset;
  if (((unsigned long)address & ~PAGE_MASK) != ~PAGE_MASK) {
    page = parse_ptabs_write((unsigned long)address, &offset);
    if (page != -EFAULT) {
      *(unsigned short *)(page + offset) = val;
      return 0;
    }
    else {
      enter_kdebug("int __put_user_short returns efault");
      return -EFAULT;
    }
  }
  else {
    if ((__put_user_byte((unsigned char)val, address) != -EFAULT) && 
	(__put_user_byte((unsigned char)(val >> 8), address+1) != -EFAULT)) {
      return 0;
    }
    else {
      enter_kdebug("int __put_user_short returns efault");
      return -EFAULT;
    }
  }
#else
  copy_to_user (address, &val, sizeof(val));
#endif
}

int __put_user_long(unsigned long val,   const void *address)
{
#if 0
  unsigned long page, offset;
  if (((unsigned long)address & ~PAGE_MASK) <= (PAGE_SIZE - sizeof(val))) {
    page = parse_ptabs_write((unsigned long)address, &offset);
    if (page != -EFAULT) {
      *(unsigned long *)(page + offset) = val;
      return 0;
    }
    else {
      enter_kdebug("int __put_user_long returns efault");
      return -EFAULT;
    }
  }
  else {
    switch ((unsigned long)address &3) 
      {
      case 1:
      case 3:
	{
	  if ((__put_user_byte((unsigned char)val, address) != -EFAULT)&& 
	      (__put_user_short((unsigned short)(val>>8), address+1) != -EFAULT) &&
	      (__put_user_byte((unsigned char)(val >> 24), address + 3) != -EFAULT))
	    {
	      return 0;
	    }
	case 2:
	  {
	    if ((__put_user_short((unsigned short)val, address) != -EFAULT)&& 
		(__put_user_short((unsigned short)(val >> 16), address+2) != -EFAULT))
	      {
		return 0;
	      }
	  }
	}
      }
    enter_kdebug("int __put_user_long returns efault");
    return -EFAULT;
  }
#else
  copy_to_user (address, &val, sizeof(val));
#endif
}

