/* $Id: config.h,v 1.1.1.1 1999/04/06 19:36:22 yoonho Exp $ */

#ifndef __L4_MIPS_CONFIG_H
#define __L4_MIPS_CONFIG_H

#include <asm/processor.h>	/* for TASK_SIZE */

#define USE_PRIOS		/* L4 priorities for Linux server
				   kernel threads */
#define USE_SMALL_SPACES 64	/* do we use small address spaces, and
				   their size in MB */
/* #define USE_SUPER_CLAN */	/* use supervisor (rmgr) for all task
				   creations, yielding "flat" clan */
/* #define TAME_SERVER */	/* only use machine-cli for PIC
				   programming, and use irq-lock;
				   implied by __SMP__ */
/* #define BROKEN_L4_SCHEDULE */	/* l4_thread_schedule (and prios)
				   don't work -- use on old versions of L4 */

#define PRIO_IRQ(x) (144 - (x))	/* x = 15..0  -> prio 129..144 */
#define PRIO_BOTTOM_HALF (128)
#define PRIO_KERNEL 127
#define PRIO_ROOT 100
#define PRIO_USER_PROCESS 10

#define MCP_SUPER   255
#define MCP_KERNEL  100
#define MCP_USER    0

/* L4 thread numbers for Linux server kernel threads */

#define LTHREAD_NO_LINUX_CHIEF	(0)
#define LTHREAD_NO_LINUX_SERVER	(3)
#define LTHREAD_NO_PROC_UNSELECT (2)
#define LTHREAD_NO_IRQ(x) 	(16 + (x)) /* x = 0..15  -> threadno 16..31*/
#define LTHREAD_NO_BOTTOM_HALF 	(32)
#define LTHREAD_NO_ROOT_EXEC 	(33)
#define LTHREAD_NO_ROOT_PAGER	(34)
#define LTHREAD_NO_SIG_SEGV	(35)


#define LTHREAD_NO_USER_THREAD	(0)
#define LTHREAD_NO_SIGNAL_THREAD	(1)
#define NO_IRQS 16		/* number of machine interrupts */

/* stack sizes */
#define INIT_USER_STACK_START 1021
#define STACK_SIZE_CHIEF 512
#define STACK_SIZE_PROC_UNSELECT 512
#define STACK_SIZE_IRQ (1024)
#define STACK_SIZE_BOTTOM_HALF (1024)
#define STACK_SIZE_ROOT_EXEC (1024)
#define STACK_SIZE_SIG_SEGV (512)
#define STACK_SIZE_USIGNAL (512)
#define STACK_SIZE_UEMULIB (512)
#define STACK_SIZE_UPAGER (64)

/* L4 task numbers */
#define TASK_NO_MIN (10)
#define TASK_NO_MAX (2047)

/* basis address for shared data */
#define SHARED_DATA_ADDRESS (TASK_SIZE)
#define EMULIB_CODE_ADDRESS (TASK_SIZE + 0x8000)


/* address of kernel info page */
#define KERNEL_INFO_PAGE_ADDRESS (0x1000)

/* end of user-configurable section */

/* some invariants follow */
#ifdef __SMP__
# define TAME_SERVER
#endif

#ifdef BROKEN_L4_SCHEDULE
# undef USE_PRIOS
# undef USE_SMALL_SPACES
# ifndef TAME_SERVER
#  define TAME_SERVER
# endif
#endif

#endif /* ! __L4_MIPS_CONFIG_H */
