#ifndef __L4_MEMORY_H__ 
#define __L4_MEMORY_H__ 

#include <linux/mm.h>
#include <asm/pgtable.h>
#include <asm/uaccess.h>
/* #include <l4/kdebug.h> */
#include <l4/ipc.h>

#ifndef __mips__
# include <l4/kernel.h>
#else
# define l4_kernel_info l4_kernel_info_t
# include <l4/sigma0.h>
# undef l4_kernel_info
#endif

/* #define DEBUG_KO */
/* #define DEBUG_REQUEST_KO */

#ifdef DEBUG_KO
#define KO(x) ko(x)
#else
#define KO(x) 
#endif
#ifdef DEBUG_REQUEST_KO
#define RKO(x) ko(x)
#else
#define RKO(x) 
#endif

extern l4_kernel_info_t *l4_kernel_info;

/*
 * defines for functions
 */

#define L4_ACCESS_MASK (2L)
#define L4_READ_ACCESS (0)
#define L4_WRITE_ACCESS (2)

#define L4_PAG_OK (0)
#define L4_PAG_BAD_ACCESS (-1)
#define L4_PAG_TEMP_NOT_PRESENT (-2)

extern char _stext, _etext, _edata, _end;		/* defined in head.S */

#define LINUX_MEM_START ((unsigned) &_stext)

#define L4_DEV_PAGE_SIZE (0x400000U)
#define L4_LOG2_DEV_PAGE (22)
#define L4_DEV_PAGE_MASK (~(L4_DEV_PAGE_SIZE - 1))
#define L4_DEV_PAGE(x) ((x) - 0x40000000U)
#define L4_DEV_PAGE_ALIGN(addr)	(((addr)+L4_DEV_PAGE_SIZE-1)&L4_DEV_PAGE_MASK)

#define RP_WRITABLE 	0
#define RP_NOT_WRITABLE 1
#define RP_NOT_MAPPED 	2
#define RP_RESERVED_COLOR 	3

#define PF_EUSER (4)
#define PF_EKERNEL (0)
#define PF_EWRITE (2)
#define PF_EREAD (0)
#define PF_EPROTECTION (1)
#define PF_ENOTPRESENT (0)

extern char emu_lib_text[PAGE_SIZE];

unsigned long l4_paging_init(unsigned long *memory_start_p, 
			     unsigned long *memory_end_p);
void create_kernel_pager(void);
void change_pager(int thread_no);


void 
l4_vmfree_area_pages(unsigned long address, unsigned long size);
void 
l4_vmalloc_area_pages(unsigned long address, unsigned long size);

int 
request_page_from_sigma0(unsigned long address);
int 
request_virtual_page_from_sigma0(unsigned long vm_addr, unsigned long page);
int 
request_dev_page_from_sigma0(dword_t fault_address, dword_t pte_val);
void
request_zero_page_from_sigma0(void);

int 
setup_kernel_info_page(void);

void 
root_pager(void);

int 
handle_pagefault(void **msg, dword_t *fault_address, dword_t *faulting_eip);
int 
l4_do_page_fault(unsigned long address, unsigned long error_code);

extern inline int
adapter_page(unsigned long addr)
{
  return (addr > 0x80000000U);
}

extern inline pte_t * 
lookup_pte(pgd_t *page_dir, unsigned long pf_address)
{
  /*
   * find the page table entry within the page table hierarchy
   */
  pgd_t *pgd = page_dir + (pf_address >> PGDIR_SHIFT) ;
  if (pgd_present(*pgd))
    {
      pmd_t *pmd = pmd_offset(pgd, pf_address);
      if (pmd_present(*pmd))
	{
	  pte_t *pte=pte_offset(pmd, pf_address);
	  return pte;
	}
    }
  return NULL;
}

extern inline unsigned long  
parse_ptabs_read(unsigned long address, unsigned long *offset) {

  pte_t *ptep = lookup_pte((pgd_t *)current->addr_limit.seg, address);
#ifdef DEBUG_PARSE_PTABS_READ
  printk("ppr: pdir: %p, address: %lx, ptep: %p\n", 
	 (pgd_t *)current->addr_limit.seg, address, ptep);
#endif
  if (! ((ptep != NULL) && pte_present(*ptep) && pte_read(*ptep)) ) {
    if (l4_do_page_fault(address, PF_EKERNEL|PF_EREAD|PF_ENOTPRESENT) == -1) {
      return -EFAULT;
    } 

    if (ptep == NULL)
      ptep = lookup_pte((pgd_t *)current->addr_limit.seg, address);
    if (! (pte_present(*ptep) && pte_read(*ptep)) )
      panic("parse_ptabs_read: pte page still not present\n");

  }
  *offset = address & ~PAGE_MASK;
  return pte_page(*ptep);
}

extern inline unsigned long  
parse_ptabs_write(unsigned long address, unsigned long *offset) {

  pte_t *ptep = lookup_pte((pgd_t *)current->addr_limit.seg, address);
#ifdef DEBUG_PARSE_PTABS_WRITE
  printk("ppw: pdir: %p, address: %lx, ptep: %p\n", 
	 (pgd_t *)current->addr_limit.seg, address, ptep);
#endif
  if ( (ptep == NULL)  || !pte_present(*ptep) ) {
    if (l4_do_page_fault(address, PF_EKERNEL|PF_EWRITE|PF_ENOTPRESENT) == -1)
      return -EFAULT;
  }
  else if (!pte_write(*ptep)) {
    if (l4_do_page_fault(address, PF_EKERNEL|PF_EWRITE|PF_EPROTECTION) == -1)
      return -EFAULT;
  }
  
  if (ptep == NULL)
    ptep = lookup_pte((pgd_t *)current->addr_limit.seg, address);
  if ( (ptep == NULL)  || !pte_present(*ptep) || !pte_write(*ptep) ) 
    panic("parse_ptabs_read: pte page still not present or writable\n");

  *offset = address & ~PAGE_MASK;
  return pte_page(*ptep);
}


#endif
