/* $Id: sched.h,v 1.1.1.1 1999/04/06 19:36:24 yoonho Exp $ */

#ifndef __L4_MIPS_SCHED_H
#define __L4_MIPS_SCHED_H

#include <linux/sched.h>

#include <l4/types.h>
#include <l4/ipc.h>
/* #include <l4/kdebug.h> */

#include "task.h"

extern int idle_sleeping;	/* in irq.c */
extern int nr_running_user;

/* check if there is work left to do in the kernel; used in the timer
   interrupt handler */
extern inline void
check_need_resched(void)
{
  if (idle_sleeping
      && nr_running > nr_running_user)
    {
      current->need_resched = 1;
    }
}

/* bottom-half and top-half threads use this routine to check if they
   need to wake up a sleeping kernel */
extern inline void 
wakeup_idle_if_needed(void)
{
  /* when in an irq service routine, we must make sure the
     wakeup request will really wake up the process.  so if the
     kernel server is idling, wake it up. */
  if (current->need_resched)
    {
      if (idle_sleeping)
	{
	  l4_msgdope_t dummydope;
	  dword_t foo;
	  if (l4_i386_ipc_call(kernel_thread_id,
			       0, 0xbbbbbbbb, 0xdeadbeef, 
			       0, &foo, &foo,
			       L4_IPC_TIMEOUT(0,1,0,0,0,0), /* rcv = inf,
							       snd = 0 */
			       &dummydope))
	    kd_display("wake_idle_if_needed: ipc failed\\r\\n");
	}
      
    }
}

#endif /* ! __L4_MIPS_SCHED_H */
