/* $Id: task.h,v 1.1.1.1 1999/04/06 19:36:24 yoonho Exp $ */

#ifndef __L4_I386_TASK_H
#define __L4_I386_TASK_H

#ifndef __ASSEMBLY__
#include <linux/sched.h>
#include <l4/types.h>
#include "ids.h"

int root_task_execute(int (*subroutine)(int arg), int arg);
void start_root_task_execute_thread(void);
void sig_kill_received(void);

extern l4_threadid_t template_id;
extern l4_sched_param_t template_schedparam;
extern l4_threadid_t kernel_thread_id;
extern unsigned long kernel_taskno;

void task_no_init(void);
int task_no_alloc(void);
int task_no_free(int n);

/* task_to_proc manipulations */
#define L4_IDLE_STACK_USAGE (sizeof(l4_threadid_t) + sizeof(unsigned long))
void set_task_to_proc_entry(int task_no, struct task_struct *p);
void clear_task_to_proc_entry(int task_no);
struct task_struct *get_task_struct(int task_no);

#endif /* ! __ASSEMBLY__ */

#endif /* ! __L4_I386_TASK_H */
