#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>

#include <linux/ptrace.h>
#include <linux/kernel.h>
#include <linux/sched.h>

#include "../include/task.h"

void switch_from_idle_to_user(struct task_struct *p);
void begin_atomic(void);
void end_atomic(void);
int l4_ipc_wait(l4_threadid_t *);
int l4_ipc_send(l4_threadid_t);

extern int idle_sleeping;

void c_l4_idle(void)
{
  int error;
  struct task_struct *p;
  l4_threadid_t src_id;

  for(;;) {
    begin_atomic();
    
    if (current->need_resched) {
      end_atomic();
      schedule();
      continue;
    }
    
    idle_sleeping = 1;
    error = l4_ipc_wait(&src_id);
    if (!error) {
      if (src_id.id.task != kernel_taskno) {
	p = get_task_struct(src_id.id.task);
	if (p && !atomic_read(&p->tss.under_kernel_control)) {
	  /* something went wrong, we don't expect a system call now */
	  switch_from_idle_to_user(p);
	  /* we return here if someone switches back to us */
	  continue;
	}
	else {
	  /* complain about unexpected system call */
	  continue;
	}
      }
      else {
	/* wakeup, send reply */
	l4_ipc_send(src_id);
	continue;
      }
      
    } 
    else {
      /* complain about ipc error */
      continue;
    }
  }
}
#if 0
dispatch_message:

for(;;) {
  for(;;) {
    p->under_kernel_control = 1;
    switch (order) {
    case SYSCALL:
      dispatch_system_call();
      if (p->tss.under_kernel_control != 1) {
	start_thread_really();
	no_reply = 1; /* no reply ???? */
      }
      break;
    case EXCEPTION:
      deliver_signal();
      break;
    default:
      no_reply = l4_handle_page_fault(); /* no_reply == 1 -> segv */
      break;
    }

    if (no_reply)
      break;

    cli();

    if (intr_count == 0)
      if (bh_active & bh_mask)
	handle_bottom_halfs();

    if (need_reschedule) {
      sti();
      schedule();
      cli();
    }
    
    p->under_kernel_control = 0;
    err = replay_and_wait(src, &src);
    if (!err) {
      p = lookup_process();
      if (p == myself) {
	/* message for me, handle it */
	continue;
      }
      
      if (src.id.taskno != kernel_task_no) {
	if (!p->tss.under_kernel_control) {
	  put_sig_kill_received_on_stack();
	  switch_stack(p->tss.kernel_stack);
	  continue;
	}
	else {
	  /* complain about unexpected msg */
	  brk;
	}
      }
      else {
	/* wakeup */
	send_reply(src);
	break;
      }
    }
  }
  push_sig_kill_received_on_stack();
  switch_to_idle_task();
  schedule();
  goto idle_loop;
}
#endif
