#include <linux/linkage.h>
#include <linux/sched.h>
#include <asm/processor.h>

#include "../include/config.h"
#include "../include/l4_thread.h"
#include "../include/l4_memory.h"
#include "../include/ids.h"
#include "../include/user.h"
#include "../include/debug.h"

#include <l4/syscalls.h>
/* #include <l4/kdebug.h> */



#define __str2(x) #x
#define __str(x) __str2(x)

asmlinkage void start_kernel(void);

void linux_startup(void);


/* This routine is invoked from the assembly startup routine in head.S.
   We basically only start our service thread and leave the rest to
   it.

   XXX After that we should start to handle redirected messages if
   there are any. */
void
__linux_startup(void)
{
#ifdef __i386__
  /* clear direction flag, gcc expects that */
  asm("cld");
#endif

  create_thread(LTHREAD_NO_LINUX_SERVER, linux_startup, 
		(char *)init_stack + sizeof(init_stack) 
		- sizeof(l4_threadid_t));
  for (;;) {
    l4_sleep(-1);
    enter_kdebug("__linux_startup return from sleep");
  }
}

extern char __bss_start;
void
linux_startup(void)
{
#ifdef __i386__
  /* clear direction flag, gcc expects that */
  asm("cld");
#endif

  /* clear bss */
  memset(&__bss_start, 0, (unsigned)&_end - (unsigned)&__bss_start);

  /* copy code of emulation library to special page and create IDT for
     user threads */
  if ((unsigned long)&emulib_text_end - (unsigned long)&emulib_text_start >
      PAGE_SIZE)
    enter_kdebug("size of emulib > PAGESIZE");

  memcpy(emu_lib_text, &emulib_text_start, 
	 (unsigned long)&emulib_text_end - (unsigned long)&emulib_text_start);

#ifdef __i386__
  {
    extern long idt_table;
    struct entry_t {unsigned short w0, w1,w2,w3;} ;
    struct entry_t *entries = 
      (struct entry_t *)((unsigned long)emu_lib_text + 
			 ((unsigned long)&idt_table - EMULIB_CODE_ADDRESS));
    unsigned short int tmp;
    int i;

    for (i=0; i<20; i++, entries++)
      {
	tmp = entries->w1;
	entries->w1 = entries->w3;
	entries->w3 = tmp;
      }
  }
#endif
  
  /* cache L4 thread id on the stack */
  {
    unsigned esp;
#ifdef __i386__
    asm("movl     %%esp, %0\n\t" : "=r" (esp) : /* No input */);
#else
    asm("move %0,$sp\n\t" : "=r" (esp) : /* No input */);
#endif
    
    put_l4_id_to_stack(esp, l4_myself());
  }

  /* invoke Linux startup routine */
  start_kernel();

  enter_kdebug("start_kernel returned");
  for(;;) ;
}
