#include <linux/config.h>
#include <linux/tasks.h>

#include <asm/asm.h>
/* #include <asm/cacheops.h> */
#include <asm/current.h>
#include <asm/offset.h>
#include <asm/processor.h>
#include <asm/regdef.h>
#include <asm/cachectl.h>
#include <asm/mipsregs.h>
#include <asm/mipsconfig.h>
/* #include <asm/stackframe.h> */
#include <asm/bootinfo.h>
#include <asm/cpu.h>

    	.text
/*
 * Kernel entry point
 */
NESTED(kernel_entry, 16, sp)
	.set	noreorder
	/* The following two symbols are used for kernel profiling. */
	EXPORT(stext)
	EXPORT(_stext)

	/* Determine which MIPS variant we are running on. */
	b	cpu_probe
	 nop

probe_done:

	/* The firmware/bootloader passes argc/argp/envp
	 * to us as arguments.  But clear bss first because
	 * the romvec and other important info is stored there
	 * by prom_init().
	 */
	la	t0, _edata
	sw	zero, (t0)
	la	t1, (_end - 4)
1:
	addiu	t0, 4
	bne	t0, t1, 1b
	 sw	zero, (t0)

	jal	prom_init /* prom_init(argc, argv, envp); */
	 nop
#ifdef CONFIG_SGI
	jal	sgi_sysinit
	 nop
#endif

#ifdef CONFIG_COBALT_MICRO_SERVER
	jal	SetUpBootInfo
	 nop
#endif

#if 0 
	/* I hope, we don't need this. Jean */   
	/*
	 * Determine the mmu/cache attached to this machine,
	 * then flush the tlb and caches.  On the r4xx0
	 * variants this also sets CP0_WIRED to zero.
	 */
	jal	loadmmu
	 nop
#endif
	/*
	 * Stack for kernel and init, current variable
	 */
	la	$28, init_task_union
	addiu	t0, $28, KERNEL_STACK_SIZE-32
	sw	t0, kernelsp
	subu	sp, t0, 4*SZREG

#if 0    
	/* Disable coprocessors */
	mfc0	t0, CP0_STATUS
	li	t1, ~(ST0_CU1|ST0_CU2|ST0_CU3|ST0_KX|ST0_SX)
	and	t0, t1
	or	t0, ST0_CU0
	mtc0	t0, CP0_STATUS
#endif    

1:	jal	linux_startup
	 nop
	/*
	 * Main should never return here, but
	 * just in case, we know what happens.
	 */
	b	1b
	 nop					# delay slot
	END(kernel_entry)
    
	/* CPU type probing code, called at Kernel entry. */
	LEAF(cpu_probe)
	mfc0	t0, CP0_PRID
	la	t3, mips_cputype
	andi	t1, t0, 0xff00
	li	t2, PRID_IMP_R2000
	bne	t1, t2, 1f
	 andi	t0, 0x00ff

	li	t2, CPU_R2000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R3000
	bne	t1, t2, 1f
	 nop

	li	t2, PRID_REV_R3000A
	bne	t0, t2, 9f
	 nop

	li	t2, CPU_R3000A
	b	probe_done
	sw	t2, (t3)
9:
	li	t2, CPU_R3000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R6000
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R6000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R4000
	bne	t1, t2, 1f
	 nop

	li	t2, PRID_REV_R4400
	bne	t0, t2, 9f
	 nop

	li	t2, CPU_R4400SC
	b	probe_done
	 sw	t2, (t3)
9:
	li	t2, CPU_R4000SC
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R6000A
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R6000A
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R10000
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R10000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R8000
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R8000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R4600
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R4600
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R4700
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R4700
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R4650
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R4650
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_R5000
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_R5000
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, PRID_IMP_NEVADA
	bne	t1, t2, 1f
	 nop

	li	t2, CPU_NEVADA
	b	probe_done
	 sw	t2, (t3)
1:
	li	t2, CPU_UNKNOWN
	sw	t2, (t3)

	b	probe_done
	 nop
	END(cpu_probe)

/*
 * This buffer is reserved for the use of the cache error handler.
 */
		.data
		EXPORT(cache_error_buffer)
		.fill	32*4,1,0

EXPORT(kernelsp)
		PTR	0
		.text

		.org	0x1000
EXPORT(swapper_pg_dir)

		.org	0x2000
EXPORT(empty_bad_page)

		.org	0x3000
EXPORT(empty_bad_page_table)

		.org	0x4000
EXPORT(invalid_pte_table)

		.org	0x5000
/* XXX This label is required to keep GAS trying to be too clever ...
   Bug?  */
dummy:
/*
 * Align to 8kb boundary for init_task_union which follows in the
 * .text segment.
 */
		.align	13
