/* $Id: setup.c,v 1.1.1.1 1999/04/06 19:36:26 yoonho Exp $
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1995  Linus Torvalds
 * Copyright (C) 1995, 1996, 1997, 1998  Ralf Baechle
 * Copyright (C) 1996  Stoned Elipot
 */
#include <linux/config.h>
#include <linux/errno.h>
#include <linux/hdreg.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stddef.h>
#include <linux/string.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>
#include <linux/malloc.h>
#include <linux/user.h>
#include <linux/utsname.h>
#include <linux/a.out.h>
#include <linux/tty.h>
#ifdef CONFIG_BLK_DEV_RAM
#include <linux/blk.h>
#endif
#ifdef CONFIG_RTC
#include <linux/ioport.h>
#include <linux/timex.h>
#endif

#include <asm/asm.h>
#include <asm/bootinfo.h>
#include <asm/cachectl.h>
#include <asm/ide.h>
#include <asm/io.h>
/* #include <asm/stackframe.h> */
#include <asm/system.h>
#include <asm/pgtable.h>
#ifdef CONFIG_SGI
/* #include <asm/sgialib.h> */
#endif

#include "../include/config.h"
#include "../include/l4_memory.h"
#include "../include/task.h"
#include "../include/rmgr.h"
#include "../include/drivers.h"
#include "../include/ids.h"

struct mips_cpuinfo boot_cpu_data = { NULL, NULL, 0 };

/*
 * Not all of the MIPS CPUs have the "wait" instruction available.  This
 * is set to true if it is available.  The wait instruction stops the
 * pipeline and reduces the power consumption of the CPU very much.
 */
char wait_available;

/*
 * Do we have a cyclecounter available?
 */
char cyclecounter_available;

/*
 * There are several bus types available for MIPS machines.  "RISC PC"
 * type machines have ISA, EISA, VLB or PCI available, DECstations
 * have Turbochannel or Q-Bus, SGI has GIO, there are lots of VME
 * boxes ...
 * This flag is set if a EISA slots are available.
 */
int EISA_bus = 0;

/*
 * Milo passes some information to the kernel that looks like as if it
 * had been returned by a Intel PC BIOS.  Milo doesn't fill the passed
 * drive_info and Linux can find out about this anyway, so I'm going to
 * remove this sometime.  screen_info contains information about the 
 * resolution of the text screen.  For VGA graphics based machine this
 * information is being use to continue the screen output just below
 * the BIOS printed text and with the same text resolution.
 */
struct screen_info screen_info = DEFAULT_SCREEN_INFO;

#ifdef CONFIG_BLK_DEV_FD
extern struct fd_ops no_fd_ops;
struct fd_ops *fd_ops;
#endif

#ifdef CONFIG_BLK_DEV_IDE
extern struct ide_ops no_ide_ops;
struct ide_ops *ide_ops;
#endif

extern struct rtc_ops no_rtc_ops;
struct rtc_ops *rtc_ops;

extern struct kbd_ops no_kbd_ops;
struct kbd_ops *kbd_ops;

/*
 * Setup information
 *
 * These are intialized so they are in the .data section
 */
unsigned long mips_memory_upper = KSEG0; /* this is set by kernel_entry() */
unsigned long mips_cputype = CPU_UNKNOWN;
unsigned long mips_machtype = MACH_UNKNOWN;
unsigned long mips_machgroup = MACH_GROUP_UNKNOWN;
unsigned long mips_tlb_entries = 48; /* Guess which CPU I've got :) */

unsigned char aux_device_present;
/* extern int _end; */

/* extern char empty_zero_page[PAGE_SIZE]; */

/*
 * This is set up by the setup-routine at boot-time
 */
#define PARAM	empty_zero_page
#if 0
#define ORIG_ROOT_DEV (*(unsigned short *) (PARAM+0x1FC))
#define AUX_DEVICE_INFO (*(unsigned char *) (PARAM+0x1FF))
#endif
#define LOADER_TYPE (*(unsigned char *) (PARAM+0x210))
#define KERNEL_START (*(unsigned long *) (PARAM+0x214))
#define INITRD_START (*(unsigned long *) (PARAM+0x218))
#define INITRD_SIZE (*(unsigned long *) (PARAM+0x21c))

static char command_line[CL_SIZE] = { 0, };
       char saved_command_line[CL_SIZE];
extern char arcs_cmdline[CL_SIZE];

/*
 * The board specific setup routine sets irq_setup to point to a board
 * specific setup routine.
 */
void (*irq_setup)(void);

/*
 * mips_io_port_base is the begin of the address space to which x86 style
 * I/O ports are mapped.
 */
unsigned long mips_io_port_base;

/*
 * isa_slot_offset is the address where E(ISA) busaddress 0 is is mapped
 * for the processor.
 */
unsigned long isa_slot_offset;

__initfunc(static void default_irq_setup(void))
{
	panic("Unknown machtype in init_IRQ");
}

__initfunc(void setup_arch(char **cmdline_p,
           unsigned long * memory_start_p, unsigned long * memory_end_p))
{
	unsigned long memory_end;
	void cobalt_setup(void);
	void decstation_setup(void);
	void deskstation_setup(void);
	void jazz_setup(void);
	void sni_rm200_pci_setup(void);
	void sgi_setup(void);

	/* Save defaults for configuration-dependent routines.  */
	irq_setup = default_irq_setup;

#ifdef CONFIG_BLK_DEV_FD
	fd_ops = &no_fd_ops;
#endif

#ifdef CONFIG_BLK_DEV_IDE
	ide_ops = &no_ide_ops;
#endif

	rtc_ops = &no_rtc_ops;
	kbd_ops = &no_kbd_ops;

	switch(mips_machgroup)
	{
#ifdef CONFIG_COBALT_MICRO_SERVER
	case MACH_GROUP_COBALT:
		cobalt_setup();
		break;
#endif
#ifdef CONFIG_MIPS_JAZZ
	case MACH_GROUP_JAZZ:
		jazz_setup();
		break;
#endif
#ifdef CONFIG_SGI
	case MACH_GROUP_SGI:
		sgi_setup();
		break;
#endif
#ifdef CONFIG_SNI_RM200_PCI
	case MACH_GROUP_SNI_RM:
		sni_rm200_pci_setup();
		break;
#endif
	default:
		panic("Unsupported architecture");
	}

	memory_end = mips_memory_upper;
	/*
	 * Due to prefetching and similar mechanism the CPU sometimes
	 * generates addresses beyond the end of memory.  We leave the size
	 * of one cache line at the end of memory unused to make shure we
	 * don't catch this type of bus errors.
	 */
	memory_end -= 128;
	memory_end &= PAGE_MASK;

        strncpy (command_line, arcs_cmdline, CL_SIZE);
	memcpy(saved_command_line, command_line, CL_SIZE);
	saved_command_line[CL_SIZE-1] = '\0';

	*cmdline_p = command_line;
	*memory_start_p = (unsigned long) &_end;
	*memory_end_p = memory_end;

#ifdef CONFIG_BLK_DEV_INITRD
	if (LOADER_TYPE) {
		initrd_start = INITRD_START;
		initrd_end = INITRD_START+INITRD_SIZE;
		if (initrd_end > memory_end) {
			printk("initrd extends beyond end of memory "
			       "(0x%08lx > 0x%08lx)\ndisabling initrd\n",
			       initrd_end,memory_end);
		initrd_start = 0;
		}
	}
#endif
	/*
	 * L4Linux-specific initializations follow
	 */

	/* set the main server id */
	kernel_thread_id = get_l4_id_from_stack();
	kernel_taskno = kernel_thread_id.id.task*4;

	/* initialize memory management */
	l4_paging_init(memory_start_p, memory_end_p);

	/* request kernel info page */
	if (setup_kernel_info_page())
	  {
	    enter_kdebug("sigma 0 denied mapping of kernel info page");
	  }
	else
	  {
	    if (l4_kernel_info == (l4_kernel_info_t *)0x1000)
	      pg0[1] = (0x1000 |_PAGE_PRESENT | _PAGE_USER | _PAGE_ACCESSED);
	    else
	      enter_kdebug("wrong address");
	  }

	/* initialize resource-manager-interface library */
	if (rmgr_init())
	  printk("RMGR found at %x.%x\n", rmgr_id.id.task, rmgr_id.id.lthread);
	else
	  printk("No RMGR found.\n");

#ifdef USE_PRIOS
	/* OK, before we start any other task/thread, set up sigma0's and
	   our own priority correctly so that newly started threads derive
	   the correct priority. */
	rmgr_set_prio(kernel_thread_id, PRIO_ROOT);
	
	if (! have_rmgr)
	  {
	    /* also set the priority for Sigma0 */
	    l4_threadid_t foo_id = L4_INVALID_ID, sigma0_id = L4_INVALID_ID;
	    dword_t foo;

#ifndef __mips__
	    l4_thread_ex_regs(kernel_thread_id, -1, -1, 
			      &foo_id, &sigma0_id, &foo, &foo, &foo);
#else  /* __mips__ */
	    l4_thread_ex_regs(kernel_thread_id, -1, -1, 
			      &foo_id, &sigma0_id, &foo, &foo);
#endif /* __mips__ */
	    rmgr_set_prio(sigma0_id, PRIO_ROOT);
	  }
#endif

	/* init task number creation */
	task_no_init();		/* do this after rmgr_init() */

	template_id = kernel_thread_id;	/* XXX find a better place for this */
#ifndef USE_SUPER_CLAN
	/* If we use rmgr to create tasks we get the same chief and nesting
	   depth like the L4Linux server, otherwise L4Linux becomes the
	   chief and the nesting depth increases. */
	template_id.id.chief = kernel_thread_id.id.task;
	template_id.id.nest++;
#endif

	/* We use a predifined template schedparan to set the
	   priorities of our linux processes. */
	{
	  l4_threadid_t foo_id = L4_INVALID_ID;
#ifndef __mips__
	  l4_thread_schedule(kernel_thread_id, L4_INVALID_SCHED_PARAM, 
			     &foo_id, &foo_id, 
			     &template_schedparam);
#else
	  l4_thread_schedule(kernel_thread_id, 
			     ((l4_sched_param_t){sched_param:-1}), 
			     &foo_id, &foo_id, 
			     &template_schedparam, &foo_id);
#endif
	}
	template_schedparam.sp.prio = PRIO_USER_PROCESS;

#ifdef USE_SMALL_SPACES
	/* put this task (the linux server task) into a small address space */
	rmgr_set_small_space(kernel_thread_id, 1);
#endif

	/* setup /proc/l4/ */
	proc_l4_setup();

	/* setup task_to_proc */
	set_task_to_proc_entry(l4_myself().id.task, &init_task);

	/* we're a kernel thread */
	atomic_set(&current->tss.under_kernel_control, 1);

	/* disable hardware scrolling to prevent confusing the L4
           kernel debugger */
	no_scroll(NULL, NULL); 

	/* activate our kernel internal pager and setup all threads to
	 * use it */
	create_kernel_pager();
	change_pager(LTHREAD_NO_LINUX_SERVER);
	change_pager(LTHREAD_NO_LINUX_CHIEF);
}
