/* $Id: elf.h,v 1.1.1.1 1999/04/06 19:48:58 yoonho Exp $ */

#ifndef __ASM_L4_I386_ELF_H
#define __ASM_L4_I386_ELF_H

/* Linux/l4-i386 has a Linux/i386 ABI */
#include <asm-i386/elf.h>

/* But we don't have segment registers so we have to fake this part of
   struct_user_regs */

/* regs is struct pt_regs, pr_reg is elf_gregset_t (which is
   now struct_user_regs, they are different) */

#undef ELF_CORE_COPY_REGS

#define ELF_CORE_COPY_REGS(pr_reg, regs)		\
	pr_reg[0] = regs->ebx;				\
	pr_reg[1] = regs->ecx;				\
	pr_reg[2] = regs->edx;				\
	pr_reg[3] = regs->esi;				\
	pr_reg[4] = regs->edi;				\
	pr_reg[5] = regs->ebp;				\
	pr_reg[6] = regs->eax;				\
	/* fake segment registers ds, es, fs, gs */	\
	pr_reg[7] = pr_reg[8] = pr_reg[9] = pr_reg[10] = 0;\
	pr_reg[11] = regs->orig_eax;			\
	pr_reg[12] = regs->eip;				\
	/* fake segment register cs */			\
	pr_reg[13] = 0;					\
	pr_reg[14] = regs->eflags;			\
	pr_reg[15] = regs->esp;				\
	/* fake segment register ss */			\
	pr_reg[16] = 0;



#endif /* ! __ASM_L4_I386_ELF_H */

