/* $Id: hardirq.h,v 1.1.1.1 1999/04/06 19:48:59 yoonho Exp $ */

#ifndef __ASM_L4_I386_HARDIRQ_H
#define __ASM_L4_I386_HARDIRQ_H

#include <linux/tasks.h>

#include <asm/atomic.h>

#include <l4/types.h>
#include <l4/syscalls.h>

/* top-half interrupt handling synchronization

   we need to define the following interfaces:

   hardirq_trylock() returns true if no top-half is executing and the
   global irq lock is not being held.  This is used as a test if it is
   OK to start bottom-half handling.

   hardirq_endlock() is always a no-op.

   in_interrupt() returns true if the current CPU is in either a top-half
   handler or a bottom-half handler.

   synchronize_irq() waits until no CPU is executing top-half
   handlers. */

extern unsigned int local_bh_count[NR_CPUS]; /* in irq.c */
extern unsigned int local_irq_count[NR_CPUS]; /* in irq.c */

#ifdef __SMP__
extern atomic_t global_irq_count;
extern l4_threadid_t irq_lock_owner;
#endif /* __SMP__ */


extern inline int
in_interrupt(void)
{
  int cpu = smp_processor_id();
  return local_irq_count[cpu] + local_bh_count[cpu] != 0;
}

extern inline int
hardirq_trylock(int cpu)
{
#ifdef __SMP__
  return 
    atomic_read(&global_irq_count) == 0 
    && thread_equal(irq_lock_owner, L4_INVALID_ID);
#else  /* !__SMP__ */
  return local_irq_count[cpu] == 0;
#endif
}

static inline void release_irqlock(int cpu)
{
#ifdef __SMP__
	/* if we didn't own the irq lock, just ignore.. */
	if (thread_equal(irq_lock_owner, l4_myself())) {
		irq_lock_owner = L4_INVALID_ID;
	}
#endif
}

extern inline void
hardirq_endlock(int cpu)
{}				/* do nothing */

extern inline void
synchronize_irq(void)
{
#ifdef __SMP__
  if (atomic_read(&global_irq_count) == 0)
    {
      /* Wait till no other CPU handles top-halves.  The simplest way
         to ensure this is grabbing the interrupt lock. */
      cli();
      sti();
    }
#else  /* ! __SMP__ */
  barrier();
#endif /* ! __SMP__ */
}

#endif /* ! __ASM_L4_I386_HARDIRQ_H */


