#ifndef __L4_I386_PTRACE_H
#define __L4_I386_PTRACE_H

#define EBX 0
#define ECX 1
#define EDX 2
#define ESI 3
#define EDI 4
#define EBP 5
#define EAX 6
/* no ds, es , fs, gs in L4Linux */
#define ORIG_EAX 7
#define EIP 8
#define CS  9
#define EFL 10
#define UESP 11
/* no ss in L4Linux */

#define PTREGS_SIZE 48		/* in bytes */

/* we have to keep a copy of the old values around to be able to
   implement binary compatibility */

#define ORIG_I386_EBX 0
#define ORIG_I386_ECX 1
#define ORIG_I386_EDX 2
#define ORIG_I386_ESI 3
#define ORIG_I386_EDI 4
#define ORIG_I386_EBP 5
#define ORIG_I386_EAX 6
#define ORIG_I386_DS 7
#define ORIG_I386_ES 8
#define ORIG_I386_FS 9
#define ORIG_I386_GS 10
#define ORIG_I386_ORIG_EAX 11
#define ORIG_I386_EIP 12
#define ORIG_I386_CS  13
#define ORIG_I386_EFL 14
#define ORIG_I386_UESP 15
#define ORIG_I386_SS   16


#ifndef __ASSEMBLY__

/* this struct defines the way the registers are stored on the 
   stack during a system call. */

struct pt_regs {
	long ebx;
	long ecx;
	long edx;
	long esi;
	long edi;
	long ebp;
	long eax;
	long orig_eax;
	long eip;
	int  __xcs;
	long eflags;
	long esp;
};

/* Arbitrarily choose the same ptrace numbers as used by the Sparc code. */
#define PTRACE_GETREGS            12
#define PTRACE_SETREGS            13
#define PTRACE_GETFPREGS          14
#define PTRACE_SETFPREGS          15

#ifdef __KERNEL__

/* we do never interrupt a user context */
#define user_mode(regs) (0)
#define instruction_pointer(regs) ((regs)->eip)
extern void show_regs(struct pt_regs *);
#endif

#endif /* __ASSEMBLY__ */
#endif /* __L4_I386_PTRACE_H */
