/* $Id: spinlock.h,v 1.1.1.1 1999/04/06 19:49:01 yoonho Exp $ */

#ifndef __ASM_L4_I386_SPINLOCK_H
#define __ASM_L4_I386_SPINLOCK_H

#include <asm/system.h>

#ifndef __SMP__

/* in the non-SMP case, use the trivial spinlocks form the i386 port;
   they work correctly even for TAME_SERVER */
# include <asm-i386/spinlock.h>

#else  /* __SMP__ */

#include <asm/sync.h>

/*
 * Your basic spinlocks, allowing only a single thread anywhere
 */

typedef sync_queue_t spinlock_t;

/* this is typical for LINUX - stupidly we have 2 initialization methods
 * 1st: spin_lock_init(lock)
 * 2nd: lock = SPIN_LOCK_UNLOCKED
 * 
 * since we need to initialize a queue (double linked list) we have a 
 * special init value which is checked in all functions (L4_INVALID_ID)
 * and we initialize the spinlock if necessary
 */
 
#define SPIN_LOCK_UNLOCKED (spinlock_t) { L4_INVALID_ID,  }

#define spin_lock_init(x)	init_queue(x)
/*
 * Simple spin lock operations.  There are two variants, one clears IRQ's
 * on the local processor, one does not.
 *
 * We make no fairness assumptions. They have a cost.
 */

// we have to get the lock first to be in the queue - otherwise
// the following lockers can't do a closed wait

#define spin_unlock_wait(x)	do { get_lock(x);free_lock(x);} while(0)
#define spin_lock(lock)         get_lock(lock)
#define spin_unlock(lock)       free_lock(lock)
#define spin_trylock(lock)      try_lock(lock)
#define spin_lock_irq(lock)     do {get_lock_irq(lock); } while (0)
#define spin_unlock_irq(lock) 	do { free_lock(lock); __sti(); } while (0)
#define spin_lock_irqsave(lock, flags) \
	do { __save_flags(flags); get_lock_irq(lock); } while (0)

#define spin_unlock_irqrestore(lock, flags) \
	do { free_lock(lock); __restore_flags(flags); } while (0)

/*
 * Read-write spinlocks, allowing multiple readers
 * but only one writer.
 *
 * NOTE! it is quite common to have readers in interrupts
 * but no interrupt writers. For those circumstances we
 * can "mix" irq-safe locks - any writer needs to get a
 * irq-safe write-lock, but readers can get non-irqsafe
 * read-locks.
 */
#if 0

typedef struct {
    sync_queue_t queue;
    int count;
} rwlock_t;

#define RW_LOCK_UNLOCKED (rwlock_t) {{L4_INVALID_ID, } , 0 }

#else

typedef sync_queue_t rwlock_t;

#define RW_LOCK_UNLOCKED (rwlock_t) { L4_INVALID_ID, }

#endif
/*
 * On x86, we implement read-write locks as a 32-bit counter
 * with the high bit (sign) being the "write" bit.
 *
 * The inline assembly is non-obvious. Think about it.
 */

/* Volkmar: first the ugly ugly implementation ==> rw-locks are equal to 
 * full locks. hopefully we don't have races in here - then we have 
 * to come up with a better solution...
 */

#define read_lock(rw)	  get_lock(rw)
#define read_unlock(rw)   free_lock(rw)
#define write_lock(rw)    get_lock(rw)
#define write_unlock(rw)  free_lock(rw)

#define read_lock_irq(lock)	get_lock_irq(lock)
#define read_unlock_irq(lock)	do { free_lock(lock); __sti(); } while (0)
#define write_lock_irq(lock)	get_lock_irq(lock)
#define write_unlock_irq(lock)	do { free_lock(lock); __sti(); } while (0)

#define read_lock_irqsave(lock, flags)	\
	do { __save_flags(flags); __cli(); read_lock(lock); } while (0)
#define read_unlock_irqrestore(lock, flags) \
	do { read_unlock(lock); __restore_flags(flags); } while (0)
#define write_lock_irqsave(lock, flags)	\
	do { __save_flags(flags); __cli(); write_lock(lock); } while (0)
#define write_unlock_irqrestore(lock, flags) \
	do { write_unlock(lock); __restore_flags(flags); } while (0)

#endif /* __SMP__ */

#endif /* ! __ASM_L4_I386_SPINLOCK_H */

