#ifndef __ASM_L4_I386_SYSTEM_H
#define __ASM_L4_I386_SYSTEM_H

#include "../../arch/l4-i386/include/config.h"
#include <asm/processor.h>

#define switch_to(prev,next) do {					\
  /* we need to make sure this works with and without	*/		\
  /* -fomit-frame-pointer; that's why we save %epb on the stack */	\
  __asm__ __volatile__							\
    ("pushl %%ebp;	"      						\
     "pushl $1f;	"						\
     "movl %%esp, (%0);	"						\
     "movl (%1), %%esp;	"						\
     "ret;		"      						\
"1:   popl %%ebp;	"						\
     : /* no output */							\
     : "r" (& prev->tss.kernel_sp), "r" (& next->tss.kernel_sp)		\
     : "memory", "eax", "ebx", "ecx", "edx", "esi", "edi"		\
       /* force everything in memory */					\
     );									\
} while(0)

/* the stuff below has been taken from <asm-i386/system.h> */

#define nop() __asm__ __volatile__ ("nop")

#define xchg(ptr,x) ((__typeof__(*(ptr)))__xchg((unsigned long)(x),(ptr),sizeof(*(ptr))))
#define tas(ptr) (xchg((ptr),1))

struct __xchg_dummy { unsigned long a[100]; };
#define __xg(x) ((struct __xchg_dummy *)(x))

/*
 * Note: no "lock" prefix even on SMP: xchg always implies lock anyway
 */
extern inline unsigned long __xchg(unsigned long x, void * ptr, int size)
{
	switch (size) {
		case 1:
			__asm__("xchgb %b0,%1"
				:"=q" (x)
				:"m" (*__xg(ptr)), "0" (x)
				:"memory");
			break;
		case 2:
			__asm__("xchgw %w0,%1"
				:"=r" (x)
				:"m" (*__xg(ptr)), "0" (x)
				:"memory");
			break;
		case 4:
			__asm__("xchgl %0,%1"
				:"=r" (x)
				:"m" (*__xg(ptr)), "0" (x)
				:"memory");
			break;
	}
	return x;
}

/*
 * Force strict CPU ordering.
 * And yes, this is required on UP too when we're talking
 * to devices.
 *
 * For now, "wmb()" doesn't actually do anything, as all
 * Intel CPU's follow what Intel calls a *Processor Order*,
 * in which all writes are seen in the program order even
 * outside the CPU.
 *
 * I expect future Intel CPU's to have a weaker ordering,
 * but I'd also expect them to finally get their act together
 * and add some real memory barriers if so.
 */
#define mb() 	__asm__ __volatile__ ("lock; addl $0,0(%%esp)": : :"memory")
#define rmb()	mb()
#define wmb()	__asm__ __volatile__ ("": : :"memory")

/* interrupt control.. */

/* in a previous version of L4Linux, we used __cli() as an
   L4Linux-local name, only to find later that Linux now claims the
   name __cli() for itself.  So this time, in order to decrease the
   risk of a namespace clash in the future, we use a name highly
   unlikely to be used by Linux in the future. */

#define __haifischflosse_sti() __asm__ __volatile__ ("sti": : :"memory")
#define __haifischflosse_cli() __asm__ __volatile__ ("cli": : :"memory")
#define __haifischflosse_save_flags(x) \
__asm__ __volatile__("pushfl ; popl %0":"=g" (x): /* no input */ :"memory")
#define __haifischflosse_restore_flags(x) \
__asm__ __volatile__("pushl %0 ; popfl": /* no output */ :"g" (x):"memory")


/* L4Linux:  synchronization primitives */

#ifndef TAME_SERVER
/* not using IRQ lock: base synchronization primitives on interrupt control */

# if defined(__SMP__)
#  error "must use TAME_SERVER for __SMP__"
# endif

# define __sti() __haifischflosse_sti()
# define __cli() __haifischflosse_cli()
# define __save_flags(x) __haifischflosse_save_flags(x)
# define __restore_flags(x) __haifischflosse_restore_flags(x)

# define sti() __sti()
# define cli() __cli()
# define save_flags(x) __save_flags(x)
# define restore_flags(x) __restore_flags(x)

#else  /* TAME_SERVER */
/* base synchronization primitives on a queued lock.  These
   declarations look a lot like the i386/SMP declarations, but they're
   based on a different implementation */

extern void __global_cli(void);
extern void __global_sti(void);
extern unsigned long __global_save_flags(void);
extern void __global_restore_flags(unsigned long);
# define cli() __global_cli()
# define sti() __global_sti()
# define save_flags(x) ((x)=__global_save_flags())
# define restore_flags(x) __global_restore_flags(x)

# ifndef __SMP__

#  define __cli() __global_cli()
#  define __sti() __global_sti()
#  define __save_flags(x) ((x)=__global_save_flags())
#  define __restore_flags(x) __global_restore_flags(x)

# else  /* __SMP__ */

/* for SMP, we don't need CPU-local versions of interrupt-control
   primitives.  We do SMP using virtual CPUs (one virtual CPU per
   kernel thread), and because interrupt handlers have their own
   virtual CPUs, they don't interrupt the context that is trying to
   protect itself here. */
/* Volkmar: I still need cli/sti, because the enqueueing and dequeueing
 * relies on disabled interrupts. since the functions normally use 
 * cli/sti for short times only we don't have problems with that (hopefully)
 */

#  define __cli() __global_cli() 
#  define __sti() __global_sti()
/* to avoid warnings this stupid assignement */
#  define __save_flags(x) do {x = x;} while (0)
#  define __restore_flags(x) do {x = x;} while(0)

# endif /* __SMP__ */

#endif /* TAME_SERVER */

#endif /* ! __ASM_L4_I386_SYSTEM_H */
