/* $Id: unistd.h,v 1.1.1.1 1999/04/06 19:49:02 yoonho Exp $ */

#ifndef __ASM_L4_I386_UNISTD_H
#define __ASM_L4_I386_UNISTD_H

/* Linux/l4-i386 has a Linux/i386 ABI: fetch system call numbers from
   <asm-i386/unistd.h> */

/* make sure __KERNEL_SYSCALLS isn't defined for <asm-i386/unistd.h> */
#ifdef __KERNEL_SYSCALLS__
# define __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef __KERNEL_SYSCALLS__
#endif

#include <asm-i386/unistd.h>

#ifdef __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# define  __KERNEL_SYSCALLS__
#endif


#ifdef __KERNEL_SYSCALLS__

#include <linux/sched.h>
#include <linux/linkage.h>
#include <asm/ptrace.h>

#include <l4/kdebug.h>
#include "../../arch/l4-i386/include/config.h"

/* make sure these don't interfere */
#undef _syscall0
#undef _syscall1
#undef _syscall2
#undef _syscall3
#undef _syscall4
#undef _syscall5

#define __Ksyscall0(type,name) \
type name(void) \
{ \
asmlinkage long __SC__##name(void) asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall1(type,name,type1,arg1) \
type name(type1 arg1) \
{ \
asmlinkage long __SC__##name(type1 arg1) asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall2(type,name,type1,arg1,type2,arg2) \
type name(type1 arg1,type2 arg2) \
{ \
asmlinkage long __SC__##name(type1 arg1, type2 arg2) \
    asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1, arg2); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall3(type,name,type1,arg1,type2,arg2,type3,arg3) \
type name(type1 arg1,type2 arg2,type3 arg3) \
{ \
asmlinkage long __SC__##name(type1 arg1, type2 arg2, type3 arg3) \
    asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1, arg2, arg3); \
if (__res>=0) \
        return (type) __res; \
errno=-__res; \
return -1; \
}

/* WARNING: if any of the following ones want and/or modify struct
   pt_regs on its stack, we lose! */

extern inline __Ksyscall0(int,idle)
/* extern inline __Ksyscall0(int,fork) */
/* extern inline __Ksyscall2(int,clone,unsigned long,flags,char *,esp) */
/* extern inline __Ksyscall0(int,pause) */
extern inline __Ksyscall0(int,setup)
extern inline __Ksyscall0(int,sync)
extern inline __Ksyscall0(pid_t,setsid)
extern inline __Ksyscall3(int,write,int,fd,const char *,buf,off_t,count)
extern inline __Ksyscall1(int,dup,int,fd)
extern inline __Ksyscall3(int,open,const char *,file,int,flag,int,mode)
extern inline __Ksyscall1(int,close,int,fd)
extern inline __Ksyscall3(pid_t,waitpid,pid_t,pid,int *,wait_stat,int,options)

int execve(char * file, char ** argv, char ** envp);

extern inline void _exit(int exitcode)
{
  asmlinkage void __SC__exit(int exitcode) asm(SYMBOL_NAME_STR(sys_) "exit");
  __SC__exit(exitcode);
}

extern inline pid_t wait(int * wait_stat)
{
  return waitpid(-1,wait_stat,0);
}

/* start a new kernel internal thread */
pid_t kernel_thread(int (*fn)(void *), void * arg,  unsigned long flags);

#endif

#endif /* ! __ASM_L4_I386_UNISTD_H */
