/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Dump out the boot_info struct.
 */

#include <flux/x86/multiboot.h>		/* multiboot structs */
#include <flux/x86/base_vm.h>		/* phystokv */
#include <flux/c/stdio.h>		/* printf */

#include "boot.h"			/* boot_info */

void boot_info_dump()
{
	struct multiboot_info *bi = boot_info;
	struct multiboot_module *m;
	int i;

	printf("MultiBoot info flags: %08x\n", bi->flags);

	if (bi->flags & MULTIBOOT_MEMORY)
	{
		printf(" PC Memory: lower: %d, upper: %d.\n",
		       bi->mem_lower, bi->mem_upper);
	}
	if (bi->flags & MULTIBOOT_CMDLINE)
	{
		printf(" Kernel command line: `%s'\n",
			(char*)phystokv(bi->cmdline));
	}

	if (bi->flags & MULTIBOOT_MODS)
	{
		printf(" Boot modules: %d\n", bi->mods_count);
		m = (struct multiboot_module*)phystokv(bi->mods_addr);
		for (i = 0; i < bi->mods_count; i++)
		{
			printf("  Module %d: %08x-%08x (size %d)\n",
				i, m[i].mod_start, m[i].mod_end,
				m[i].mod_end - m[i].mod_start);
			if (m[i].string)
			{
				printf("   String: `%s' at %08x\n",
					(char*)phystokv(m[i].string),
					m[i].string);
			}
		}
	}

	if (bi->flags & MULTIBOOT_AOUT_SYMS)
	{
		printf(" Symbol table (a.out-style): start %08x,\n  symtab %08x, strtab %08x\n", bi->syms.a.addr, bi->syms.a.tabsize, bi->syms.a.strsize);
	}

	if (bi->flags & MULTIBOOT_BOOT_DEVICE)
	{
		printf(" Boot device: %d %d %d %d\n",
			bi->boot_device[0], bi->boot_device[1],
			bi->boot_device[2], bi->boot_device[3]);
	}
}

