/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <flux/x86/asm.h>		/* of course */
#include <flux/x86/seg.h>		/* ACC_PL_K */
#include <flux/x86/gate_init.h>		/* GATE_ENTRY */
#include <flux/x86/base_gdt.h>		/* KERNEL_DS */

#include "intr.h"

/*
 * When debugging is enabled, clear ebp on entry into the kernel
 * so that kernel stack backtraces will terminate cleanly.
 */
#ifdef DEBUG
#define CLEAR_EBP	xorl	%ebp,%ebp
#else
#define CLEAR_EBP
#endif

	.text

#define INTERRUPT(n)                            \
	GATE_ENTRY(n + IDT_IRQ_BASE, 0f, ACC_PL_K|ACC_INTR_GATE)	;\
	P2ALIGN(TEXT_ALIGN)                     ;\
0:                                              ;\
	pushl	$(0)				;\
	pushl	$(0)				;\
	pushl   %eax                            ;\
	movl    $(n),%eax                       ;\
	jmp     allintrs

GATE_INITTAB_BEGIN(base_int_inittab)

INTERRUPT(0)
INTERRUPT(1)
INTERRUPT(2)
INTERRUPT(3)
INTERRUPT(4)
INTERRUPT(5)
INTERRUPT(6)
INTERRUPT(7)
INTERRUPT(8)
INTERRUPT(9)
INTERRUPT(10)
INTERRUPT(11)
INTERRUPT(12)
INTERRUPT(13)
INTERRUPT(14)
INTERRUPT(15)

GATE_INITTAB_END


/*
 * Macro to load the standard segment registers
 * on entry to a hardware interrupt handler.
 */
#define LOAD_SEGS                       \
        movl    $KERNEL_DS,%eax         ;\
        movw    %ax,%ds                 ;\
        movw    %ax,%es



/* XXX handle NMI - at least print a warning like Linux does.  */

/*
 * All interrupts enter here.
 * Don't have to push eax, it's already been done for us.
 */
allintrs:
        pushl   %ecx
        pushl   %edx
        pushl   %ebx
        pushl   %ebp
        pushl   %esi
        pushl   %edi
        pushl   %ds
        pushl   %es
        pushl   %fs
        pushl   %gs
	/* push interrupt number! */
	pushl 	%eax			/* must do this _before_ LOAD_SEGS */
	
	LOAD_SEGS
	CLEAR_EBP
	
	call	EXT(interrupt)
	addl	$4, %esp
/*	jmp	EXT(return_from_intr) */

/*
 * XXX This is just return_from_trap, without the annotations, which 
 * would bring us back into the trap code if anything bad happened!
 * This should be fixed sometime.
 */
return_from_intr:

        /* Return from the interrupt and restart execution.  */
        popl    %gs
        popl    %fs
        popl    %es
        popl    %ds
        popl    %edi
        popl    %esi
        popl    %ebp
        popl    %ebx
        popl    %edx
        popl    %ecx
        popl    %eax
        addl    $8,%esp
        iret



