/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Hardware interrupt management for uniprocessor x86 PC's.
 * Adapted from Fluke, ignore some of the comments (except this one :-)
 */

#include <flux/x86/pc/pic.h>
#include <flux/x86/pio.h>
#include <flux/x86/base_idt.h>
#include <flux/x86/base_gdt.h>
#include <flux/x86/gate_init.h>
#include <flux/x86/proc_reg.h>
#include <flux/c/assert.h>

#include "intr.h"

/*
 * This routine is called whenever a hardware interrupt occurs,
 * either from user mode or from supervisor mode.
 * It disables the interrupt in the PIC,
 * then wakes up the thread waiting for the appropriate interrupt.
 * Assumes the processor interrupt flag is disabled.
 */
void interrupt(unsigned long ts, unsigned irq)
{
	assert(irq < 16);

	/* Check for spurious interrupts.  */

	/* Disable the appropriate PIC interrupt enable bit.  */

	/* Check for spurious interrupts.  */

	/* Acknowledge the interrupt.
	   This must be done now rather than later in interrupt_wait(),
	   because we may not actually switch immediately
	   to the thread that woke up to handle the interrupt.  */
	pic_ack(irq);

	/* Do something. */
}

extern struct gate_init_entry base_int_inittab[];

void interrupt_boot(void)
{
	cli();

	/* XXX gate_init reloads the idt, which isn't exactly what
	 * we want, but shouldn't cause trouble.
	 */
	gate_init(base_idt, base_int_inittab, KERNEL_CS);

	pic_init(PICM_VECTBASE, PICS_VECTBASE);
	pic_disable_all();

	sti();
}


