/* 
 * Copyright (c) 1996-1995 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * This "header file" actually contains assembly language source,
 * and is included by the various crt0 files on the entry path
 * to perform generic initialization common to all environments.
 *
 * This code may trash any and all processor registers.
 * It assumes that esp is set up to point to a suitable stack
 * to make calls on; however, at the end of this code sequence
 * the stack pointer is left where it was at the beginning,
 * and nothing already on the stack (>= esp) is touched.
 */

	.text

	/* Clear the base pointer so that stack backtraces will work.  */
	xorl	%ebp,%ebp

#ifdef __ELF__

	/* Ensure that the denit code gets called on exit.  */
	pushl	$_fini
	call	EXT(atexit)
	addl	$4,%esp

	/* Call all global constructors.  */
	lea	ctors,%ebx
1:	movl	(%ebx),%eax
	orl	%eax,%eax
	jz	2f
	call	*%eax
	addl	$4,%ebx
	jmp	1b
2:
	/* No 'ret' here - go on to the rest of the init code.  */

/*
 * XXX Currently we're disabling use of the init section
 * because it doesn't work right if -Ttext is used on the linker line
 * to link a kernel (or whatever) at a specific address.
 * The problem is that the init section is before the text segment
 * in the linker script, so it gets placed at 0x080000??
 * even though the text segment has moved elsewhere.
 *
 * The direct result is the linker barfing with an error like:
 * 'Not enough room for program headers (allocated 2, need 3)'
 * This particular error is actually because of a BFD stupidity,
 * in which it blindly guesses that it will need two program segments
 * and then panics when it discovers it really needs three.
 * But even if this BFD bug didn't exist, and it guessed right,
 * the end result would still be wrong,
 * in that the init code would be by itself way out at 0x08000000
 * (which probably won't even load unless the user has >128MB of memory),
 * but we want it to be next to our init segment.
 *
 * So for now, we just don't bother using this segment at all,
 * instead placing the code to call the destructor routines
 * directly into the initialization path above.
 * Fortunately, GCC never directly outputs .init section code;
 * it only outputs entries in the .ctors and .dtors sections,
 * which work fine because they come after the text section.
 */
#if 0
	/* Call the init code.  */
	call	_init

/*
 * Header for the special section '.init',
 * which contains code to be run at initialization time.
 * It is structured as one big function,
 * with the entrypoint defined here
 * and the 'ret' instruction supplied in crtn.o;
 * any object file in the middle can add initialization code
 * simply by inserting more instructions in this section.
 */
	.section .init
	.type _init,@function
_init:
#endif 0


/*
 * Similar to the '.init' section,
 * the '.fini' section contains code to run at exit time.
 */
	.section .fini
	.type _fini,@function
_fini:

	/* Call all global destructors.  */
	pushl	%ebx
	lea	dtors,%ebx
1:	movl	(%ebx),%eax
	orl	%eax,%eax
	jz	2f
	call	*%eax
	addl	$4,%ebx
	jmp	1b
2:	popl	%ebx

/*
 * When any global variable needing a constructor is declared in C++,
 * it writes a longword into the '.ctors' section
 * which is a pointer to the appropriate constructor routine to call.
 */
	.section .ctors,"a",@progbits
	P2ALIGN(2)
	.long	-1
ctors:

/*
 * Similarly, the '.ctors' section is a list of pointers
 * to destructor routines for global C++ objects.
 */
	.section .dtors,"a",@progbits
	P2ALIGN(2)
	.long	-1
dtors:

/*
 * Finally, the '.anno' section is our own little invention;
 * it allows generic program annotations of many different kinds
 * to be collected together by the linker into "annotation tables";
 * see flux/anno.h for more information.
 */
	.section .anno,"aw",@progbits
	P2ALIGN(4)
	.globl	__ANNO_START__
__ANNO_START__:

/*
 * Now back to our normal programming...
 */
	.text

#endif /* __ELF__ */
