/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

/*
 * This file contains the code to convert a FreeBSD style slice and
 * partition number into an index into the partition table.
 *
 * This allows a disklable to be inside a DOS partition.
 */

#include <sys/types.h> 
#include <stdio.h>

#include <flux/diskpart/diskpart.h>


/*
 * This will be called by every routine that needs to access partition
 * info based on a device number.
 */

/* This code and data structure based on conversation with Bryan Ford. */

/*
 * It may be better to cache the results of the call to the lookup
 * function.  The address returned cound then be used as the `handle',
 * which would enable much faster accesses to the data.  These could
 * be compared to see if the same partition is opened more than once.
 * However, multiple aliases in the partitioning information will not
 * be detected this easily -- the bounds will still have to be checked
 * by the user.
 */

/*
 * Slice 0 is either the whole disk (when partition is also 0), or is
 * aliased (compatability slice), while Slice 1+ represent actual
 * top-level (typically DOS) partitions.
 */

struct diskpart *
diskpart_lookup_bsd_compat(struct diskpart *array, short slice, short part)
{
        struct diskpart *s;

	/* S0 is either the whole disk (p=0) or mapped to annother partition */
        if (slice == 0) {
		/* s0, p0 => whole disk */
                if (part == 0)
                        return &array[0];

		/* check compatability slice for mapping to BSD partition */
                if (array[0].type == DISKPART_DOS) {
                        int i;
                        for (i = 0; i < array[0].nsubs; i++) {
                                s = &array[0].subs[i];
                                if (s->type == DISKPART_BSD) {
                                        if (part > s->nsubs)
                                                return 0;
                                        return (&s->subs[part-1]);
                                }
                        }

			/* check for mapping to VTOC partition */
                        for (i = 0; i < array[0].nsubs; i++) {
                                s = &array[0].subs[i];
                                if (s->type == DISKPART_VTOC) { /* VTOC/UNIX */ 
                                        if (part > s->nsubs)
                                                return 0;
                                        return (&s->subs[part-1]);
                                }
                        }
                }

                if (part > array[0].nsubs)
                        return 0;
                return(&array[0].subs[part-1]);
        } else {
		/* slice != 0, find the DOS slice */
                if (array[0].type != DISKPART_DOS)
                        return 0;
                if (slice > array[0].nsubs) {
                        return 0;
		}
                s = &array[0].subs[slice-1];

                if (part == 0)
                        return (s);
                if (part > s->nsubs)
                        return 0;
                return (&s->subs[part-1]);
        }
}
