/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Default implementation of buffer routines.
 */

#include <flux/fdev.h>
#include <flux/x86/types.h>

/*
 * Copy data from a user buffer into kernel's address space.
 */
int
fdev_default_buf_copyin(void *buf, vm_offset_t off, void *dest, unsigned amt)
{
	memcpy(dest, buf + off, amt);
	return (0);
}

/*
 * Copy data from kernel address space to a user buffer.
 */
int
fdev_default_buf_copyout(void *src, void *buf, vm_offset_t off, unsigned amt)
{
	memcpy(buf + off, src, amt);
	return (0);
}

#if 0
int
fdev_default_buf_wire(void *buf, unsigned size, vm_offset_t *page_list,
			  unsigned *amt_wired)
{
}

void
fdev_default_buf_unwire(void *buf, vm_offset_t offset, unsigned size)
{
}
#endif
