/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * IRQ management.
 *
 * XXX: Does not support shared IRQs.
 */

#include <flux/fdev.h>
#include <flux/x86/base_gdt.h>
#include <flux/x86/base_idt.h>
#include <flux/x86/pio.h>
#include <flux/x86/proc_reg.h>
#include <flux/x86/pc/pic.h>
#include <flux/debug.h>
#include <stdio.h>

#include "irq.h"

static struct {
	void	(*func)(void *);
	void	*data;
} handlers[16];

void
fdev_intr_handler(unsigned irq)
{
	if (handlers[irq].func)
		(*handlers[irq].func)(handlers[irq].data);
}

/*
 * Initialize interrupt handlers.
 */
void
fdev_intr_init()
{
	fdev_intr_disable();

	gate_init(base_idt, fdev_intr_inittab, KERNEL_CS);

	pic_init(PICM_VECTBASE, PICS_VECTBASE);
	pic_disable_all();

	fdev_intr_enable();
}

/*
 * Allocate an IRQ.
 */
int
fdev_intr_alloc(unsigned irq, void (*handler)(void *), void *data, int flags)
{
	if (irq >= 16 || handlers[irq].func) {
		otsan();
		return (1);
	}
	handlers[irq].func = handler;
	handlers[irq].data = data;
	pic_enable_irq(irq);
	return (0);
}

/*
 * Deallocate an IRQ.
 */
void
fdev_intr_free(unsigned irq)
{
	pic_disable_irq(irq);
	handlers[irq].func = 0;
}

/*
 * Enable/disable interrupts.
 */
inline void
fdev_intr_enable()
{
	sti();
}

inline void
fdev_intr_disable()
{
	cli();
}
