/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Interrupt handler stubs.
 */

#include <flux/x86/asm.h>
#include <flux/x86/gate_init.h>
#include <flux/x86/seg.h>
#include "irq.h"

	.text

#define INTERRUPT(irq)			\
	GATE_ENTRY((irq) + IDT_IRQ_BASE, 0f, ACC_PL_K|ACC_INTR_GATE)	;\
	P2ALIGN(TEXT_ALIGN)		;\
0:					;\
	pushl	%eax			;\
	movl	$(irq),%eax		;\
	jmp	allints

GATE_INITTAB_BEGIN(fdev_intr_inittab)

INTERRUPT(0)
INTERRUPT(1)
INTERRUPT(2)
INTERRUPT(3)
INTERRUPT(4)
INTERRUPT(5)
INTERRUPT(6)
INTERRUPT(7)
INTERRUPT(8)
INTERRUPT(9)
INTERRUPT(10)
INTERRUPT(11)
INTERRUPT(12)
INTERRUPT(13)
INTERRUPT(14)
INTERRUPT(15)

GATE_INITTAB_END

	P2ALIGN(TEXT_ALIGN)
allints:
	pushl	%ecx				# save registers
	pushl	%edx
	pushl	%ds
	pushl	%es
	movl	%ss,%cx
	movl	%cx,%ds
	movl	%cx,%es
	cld

	movl	$1,%edx				# mask interrupting IRQ
	movl	%eax,%ecx			# and acknowledge interrupt
	cmpl	$8,%eax
	jge	1f
	inb	$0x21,%al
	shll	%cl,%edx
	orb	%dl,%al
	outb	%al,$0x21
	movb	$0x20,%al
	outb	%al,$0x20
	jmp	2f
1:
	inb	$0xa1,%al
	subl	$8,%ecx
	shll	%cl,%edx
	orb	%dl,%al
	outb	%al,$0xa1
	addl	$8,%ecx
	movb	$0x20,%al
	outb	%al,$0x20
	outb	%al,$0xa0
2:
	incl	intr_nest
	pushl	%ecx
	call	EXT(fdev_intr_handler)		# call interrupt handler
	popl	%ecx

	movl	$1,%edx				# unmask IRQ
	cli
	cmpl	$8,%ecx
	jge	1f
	inb	$0x21,%al
	shll	%cl,%edx
	notb	%dl
	andb	%dl,%al
	outb	%al,$0x21
	jmp	2f
1:
	inb	$0xa1,%al
	subl	$8,%ecx
	shll	%cl,%edx
	notb	%dl
	andb	%dl,%al
	outb	%al,$0xa1
2:
	cmpl	$1,intr_nest			# check for software intr
	jne	1f
	cmpl	$0,EXT(fdev_soft_intr_pending)
	je	1f
	movl	$0,EXT(fdev_soft_intr_pending)
	sti
	call	EXT(fdev_soft_intr)
1:
	decl	intr_nest
	popl	%es				# restore registers
	popl	%ds
	popl	%edx
	popl	%ecx
	popl	%eax
	iret

	.data
	P2ALIGN(DATA_ALIGN)
intr_nest:
	.long	0
