/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Open a device.
 */

#include <flux/fdev.h>

extern int linux_block_open(const char *, unsigned, fdev_t **);
#if 0
extern int freebsd_block_open(const char *, unsigned, fdev_t **);
#endif

int
fdev_drv_open(const char *name, unsigned flags, fdev_t **dev)
{
#if 0
	int err;

	err = linux_block_open(name, flags, dev);
	if (err != FDEV_NO_SUCH_DEVICE)
		return (err);
	err = freebsd_block_open(name, flags, dev);
	return (err);
#else
	return (linux_block_open(name, flags, dev));
#endif
}
