/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * I/O port allocation/deallocation.
 */

#include <flux/fdev.h>
#include <flux/debug.h>

#ifndef NBPW
#define NBPW	32
#endif

#define NPORTS	65536

static unsigned port_bitmap[NPORTS / NBPW];

int
fdev_port_avail(unsigned port, unsigned size)
{
	unsigned i, j, bit;

	i = port / NBPW;
	bit = 1 << (port % NBPW);
	for (j = 0; j < size; j++) {
		if (port_bitmap[i] & bit)
			return (1);
		bit <<= 1;
		if (bit == 0) {
			bit = 1;
			i++;
		}
	}
	return (0);
}

void
fdev_port_alloc(unsigned port, unsigned size)
{
	unsigned i, j, bit;

	i = port / NBPW;
	bit = 1 << (port % NBPW);
	for (j = 0; j < size; j++) {
		if (port_bitmap[i] & bit)
			panic("%s:%d: port not free", __FILE__, __LINE__);

		port_bitmap[i] |= bit;
		bit <<= 1;
		if (bit == 0) {
			bit = 1;
			i++;
		}
	}
}

void
fdev_port_free(unsigned port, unsigned size)
{
	unsigned i, j, bit;

	i = port / NBPW;
	bit = port % NBPW;
	for (j = 0; j < size; j++) {
		if ((port_bitmap[i] & bit) == 0)
			panic("%s:%d: port not alloc", __FILE__, __LINE__);

		port_bitmap[i] &= ~bit;
		bit <<= 1;
		if (bit == 0) {
			bit = 1;
			i++;
		}
	}
}
