/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Scheduler support (yeah, right!).
 */

#include <stdio.h>
#include <malloc.h>
#include <flux/fdev.h>
#include <flux/debug.h>
#include <flux/x86/proc_reg.h>

static void *volatile pending_event;


/*
 * Block waiting for an event.
 *
 * It is the caller's responsibility to disable
 * interrupts before calling this routine if that
 * is required.
 */
void
fdev_event_block(void *event)
{
	unsigned flags;

	if (!event) {
		printf("fdev_event_block called with NULL event!\n");
		return;
	}

#ifdef SCHED_DEBUG 
	printf("%s:%d: BLOCKING on event 0x%x\n", __FILE__, 
	       __LINE__, event);
#endif

	flags = get_eflags();
	cli();

#ifdef SCHED_DEBUG
	printf("%s:%d: setting pending_event to %x\n", 
	       (unsigned)event, __FUNCTION__, __LINE__);
#endif

	if (pending_event)
		printf("%s:%d: previous event clobbered\n", 
		       __FILE__, __LINE__);

	pending_event = event;

#ifdef SCHED_DEBUG
	printf("%s:%d: WAITING on event %x!\n", 
	       event, __FUNCTION__, __LINE__);
#endif
	sti();				/* RACE! */

	while(pending_event)
		/* NOTHING */;

#ifdef SCHED_DEBUG 
	printf("%s:%d: DONE waiting on event %x!\n", 
	       (unsigned)event, __FUNCTION__, __LINE__);
#endif

	set_eflags(flags);
}

/*
 * Unblock sleepers on an event.
 */
void
fdev_event_unblock(void *event)
{
#ifdef SCHED_DEBUG
	printf("%s:%d: event %p, pending_event %p\n",
	       __FILE__, __LINE__, event, pending_event);
#endif
	if (pending_event == event) {
#ifdef SCHED_DEBUG
		printf("%s:%d: PENDING EVENT == EVENT!\n", __FUNCTION__,
		       __LINE__);
#endif
		pending_event = 0;
	}
}



